/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieProject
implements KieProject {
    private static final Logger log = LoggerFactory.getLogger(KieProject.class);
    protected final Map<String, KieBaseModel> kBaseModels = new HashMap<String, KieBaseModel>();
    private KieBaseModel defaultKieBase = null;
    private KieSessionModel defaultKieSession = null;
    private KieSessionModel defaultStatelessKieSession = null;
    private Map<KieBaseModel, Set<String>> includesInKieBase = new HashMap<KieBaseModel, Set<String>>();
    protected final Map<String, KieSessionModel> kSessionModels = new HashMap<String, KieSessionModel>();

    @Override
    public ResultsImpl verify() {
        ResultsImpl messages = new ResultsImpl();
        this.verify(messages);
        return messages;
    }

    @Override
    public ResultsImpl verify(String ... kBaseNames) {
        ResultsImpl messages = new ResultsImpl();
        this.verify(kBaseNames, messages);
        return messages;
    }

    public void verify(ResultsImpl messages) {
        for (KieBaseModel model : this.kBaseModels.values()) {
            AbstractKieModule.buildKnowledgePackages((KieBaseModelImpl)model, this, messages);
        }
    }

    public void verify(String[] kBaseNames, ResultsImpl messages) {
        for (String modelName : kBaseNames) {
            AbstractKieModule.buildKnowledgePackages((KieBaseModelImpl)this.kBaseModels.get(modelName), this, messages);
        }
    }

    @Override
    public KieBaseModel getDefaultKieBaseModel() {
        return this.defaultKieBase;
    }

    @Override
    public KieSessionModel getDefaultKieSession() {
        return this.defaultKieSession;
    }

    @Override
    public KieSessionModel getDefaultStatelessKieSession() {
        return this.defaultStatelessKieSession;
    }

    @Override
    public KieBaseModel getKieBaseModel(String kBaseName) {
        return kBaseName == null ? this.getDefaultKieBaseModel() : this.kBaseModels.get(kBaseName);
    }

    @Override
    public Collection<String> getKieBaseNames() {
        return this.kBaseModels.keySet();
    }

    @Override
    public KieSessionModel getKieSessionModel(String kSessionName) {
        return kSessionName == null ? this.getDefaultKieSession() : this.kSessionModels.get(kSessionName);
    }

    protected void indexParts(Collection<InternalKieModule> kieModules, Map<String, InternalKieModule> kJarFromKBaseName) {
        for (InternalKieModule kJar : kieModules) {
            KieModuleModel kieProject = kJar.getKieModuleModel();
            for (KieBaseModel kieBaseModel : kieProject.getKieBaseModels().values()) {
                if (kieBaseModel.isDefault()) {
                    if (this.defaultKieBase == null) {
                        this.defaultKieBase = kieBaseModel;
                    } else {
                        this.defaultKieBase = null;
                        log.warn("Found more than one default KieBase: disabling all. KieBases will be accessible only by name");
                    }
                }
                this.kBaseModels.put(kieBaseModel.getName(), kieBaseModel);
                ((KieBaseModelImpl)kieBaseModel).setKModule(kieProject);
                kJarFromKBaseName.put(kieBaseModel.getName(), kJar);
                for (KieSessionModel kieSessionModel : kieBaseModel.getKieSessionModels().values()) {
                    if (kieSessionModel.isDefault()) {
                        if (kieSessionModel.getType() == KieSessionModel.KieSessionType.STATEFUL) {
                            if (this.defaultKieSession == null) {
                                this.defaultKieSession = kieSessionModel;
                            } else {
                                this.defaultKieSession = null;
                                log.warn("Found more than one default KieSession: disabling all. KieSessions will be accessible only by name");
                            }
                        } else if (this.defaultStatelessKieSession == null) {
                            this.defaultStatelessKieSession = kieSessionModel;
                        } else {
                            this.defaultStatelessKieSession = null;
                            log.warn("Found more than one default StatelessKieSession: disabling all. StatelessKieSessions will be accessible only by name");
                        }
                    }
                    ((KieSessionModelImpl)kieSessionModel).setKBase(kieBaseModel);
                    this.kSessionModels.put(kieSessionModel.getName(), kieSessionModel);
                }
            }
        }
    }

    protected void cleanIndex() {
        this.kBaseModels.clear();
        this.kSessionModels.clear();
        this.includesInKieBase.clear();
        this.defaultKieBase = null;
        this.defaultKieSession = null;
        this.defaultStatelessKieSession = null;
    }

    @Override
    public Set<String> getTransitiveIncludes(String kBaseName) {
        return this.getTransitiveIncludes(this.getKieBaseModel(kBaseName));
    }

    @Override
    public Set<String> getTransitiveIncludes(KieBaseModel kBaseModel) {
        Set<String> includes = this.includesInKieBase.get(kBaseModel);
        if (includes == null) {
            includes = new HashSet<String>();
            this.getTransitiveIncludes(kBaseModel, includes);
            this.includesInKieBase.put(kBaseModel, includes);
        }
        return includes;
    }

    private void getTransitiveIncludes(KieBaseModel kBaseModel, Set<String> includes) {
        if (kBaseModel == null) {
            return;
        }
        Set<String> incs = ((KieBaseModelImpl)kBaseModel).getIncludes();
        if (incs != null && !incs.isEmpty()) {
            for (String inc : incs) {
                if (includes.contains(inc)) continue;
                includes.add(inc);
                this.getTransitiveIncludes(this.getKieBaseModel(inc), includes);
            }
        }
    }
}

