/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.util.concurrent.Callable;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SubSingleBenchmarkRunner
implements Callable<SubSingleBenchmarkRunner> {
    public static final String NAME_MDC = "subSingleBenchmark.name";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SubSingleBenchmarkResult subSingleBenchmarkResult;
    private final SolverConfigContext solverConfigContext;
    private Throwable failureThrowable = null;

    public SubSingleBenchmarkRunner(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        this(subSingleBenchmarkResult, new SolverConfigContext());
    }

    public SubSingleBenchmarkRunner(SubSingleBenchmarkResult subSingleBenchmarkResult, SolverConfigContext solverConfigContext) {
        this.subSingleBenchmarkResult = subSingleBenchmarkResult;
        this.solverConfigContext = solverConfigContext;
    }

    public SubSingleBenchmarkResult getSubSingleBenchmarkResult() {
        return this.subSingleBenchmarkResult;
    }

    public Throwable getFailureThrowable() {
        return this.failureThrowable;
    }

    public void setFailureThrowable(Throwable failureThrowable) {
        this.failureThrowable = failureThrowable;
    }

    @Override
    public SubSingleBenchmarkRunner call() {
        MDC.put((String)NAME_MDC, (String)this.subSingleBenchmarkResult.getName());
        Runtime runtime = Runtime.getRuntime();
        ProblemBenchmarkResult problemBenchmarkResult = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult();
        Solution inputSolution = problemBenchmarkResult.readPlanningProblem();
        if (!problemBenchmarkResult.getPlannerBenchmarkResult().hasMultipleParallelBenchmarks()) {
            runtime.gc();
            this.subSingleBenchmarkResult.setUsedMemoryAfterInputSolution(runtime.totalMemory() - runtime.freeMemory());
        }
        this.logger.trace("Benchmark inputSolution has been read for subSingleBenchmarkResult ({}).", (Object)this.subSingleBenchmarkResult);
        SolverConfig solverConfig = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getSolverBenchmarkResult().getSolverConfig();
        if (this.subSingleBenchmarkResult.getSingleBenchmarkResult().getSubSingleCount() > 1) {
            solverConfig = new SolverConfig(solverConfig);
            solverConfig.offerRandomSeedFromSubSingleIndex((long)this.subSingleBenchmarkResult.getSubSingleBenchmarkIndex());
        }
        Solver solver = solverConfig.buildSolver(this.solverConfigContext);
        for (SubSingleStatistic subSingleStatistic : this.subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().values()) {
            subSingleStatistic.open((Solver<Solution>)solver);
            subSingleStatistic.initPointList();
        }
        Solution outputSolution = solver.solve(inputSolution);
        long timeMillisSpent = solver.getTimeMillisSpent();
        DefaultSolverScope solverScope = ((DefaultSolver)solver).getSolverScope();
        SolutionDescriptor solutionDescriptor = solverScope.getSolutionDescriptor();
        problemBenchmarkResult.registerScale(solutionDescriptor.getEntityCount(outputSolution), solutionDescriptor.getGenuineVariableCount(outputSolution), solutionDescriptor.getProblemScale(outputSolution));
        this.subSingleBenchmarkResult.setScore(outputSolution.getScore());
        this.subSingleBenchmarkResult.setUninitializedVariableCount(solverScope.getBestUninitializedVariableCount());
        this.subSingleBenchmarkResult.setTimeMillisSpent(timeMillisSpent);
        this.subSingleBenchmarkResult.setCalculateCount(solverScope.getCalculateCount());
        for (SubSingleStatistic subSingleStatistic : this.subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().values()) {
            subSingleStatistic.close((Solver<Solution>)solver);
            subSingleStatistic.hibernatePointList();
        }
        problemBenchmarkResult.writeOutputSolution(this.subSingleBenchmarkResult, outputSolution);
        MDC.remove((String)NAME_MDC);
        return this;
    }

    public String getName() {
        return this.subSingleBenchmarkResult.getName();
    }

    public String toString() {
        return this.subSingleBenchmarkResult.toString();
    }
}

