/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedProperties
implements Externalizable {
    protected static transient Logger logger = LoggerFactory.getLogger(ChainedProperties.class);
    private static final int MAX_CACHE_ENTRIES = Integer.parseInt(System.getProperty("org.kie.property.cache.size", "100"));
    private static final boolean CACHE_ENABLED = Boolean.parseBoolean(System.getProperty("org.kie.property.cache.enabled", "false"));
    protected static Map<CacheKey, List<URL>> resourceUrlCache = new LinkedHashMap<CacheKey, List<URL>>(){
        private static final long serialVersionUID = -2324394641773215253L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<CacheKey, List<URL>> eldest) {
            return this.size() > MAX_CACHE_ENTRIES;
        }
    };
    private List<Properties> props;
    private List<Properties> defaultProps;

    public ChainedProperties() {
    }

    public ChainedProperties(String confFileName, ClassLoader classLoader) {
        this(confFileName, classLoader, true);
    }

    public ChainedProperties(String confFileName, ClassLoader classLoader, boolean populateDefaults) {
        this.props = new ArrayList<Properties>();
        this.defaultProps = new ArrayList<Properties>();
        this.addProperties(System.getProperties());
        this.loadProperties(System.getProperty("drools." + confFileName), this.props);
        this.loadProperties(System.getProperty("user.home") + "/drools." + confFileName, this.props);
        this.loadProperties("drools." + confFileName, this.props);
        this.loadProperties(this.getResources("META-INF/drools." + confFileName, classLoader), this.props, classLoader);
        this.loadProperties(this.getResources("/META-INF/drools." + confFileName, classLoader), this.props, classLoader);
        this.loadPropertiesFromClassLoader(confFileName, classLoader, Thread.currentThread().getContextClassLoader());
        ClassLoader systemClassLoader = null;
        try {
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.loadPropertiesFromClassLoader(confFileName, classLoader, systemClassLoader);
        if (!populateDefaults) {
            return;
        }
        this.loadProperties(this.getResources("META-INF/drools.default." + confFileName, classLoader), this.defaultProps, classLoader);
        this.loadProperties(this.getResources("/META-INF/drools.default." + confFileName, classLoader), this.defaultProps, classLoader);
        this.loadDefaultsFromClassLoader(confFileName, classLoader, Thread.currentThread().getContextClassLoader());
        this.loadDefaultsFromClassLoader(confFileName, classLoader, systemClassLoader);
        if (this.defaultProps.isEmpty()) {
            try {
                Class<?> c = Class.forName("org.drools.compiler.lang.MVELDumper", false, classLoader);
                URL confURL = c.getResource("/META-INF/drools.default." + confFileName);
                this.loadProperties(confURL, this.defaultProps);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void loadDefaultsFromClassLoader(String confFileName, ClassLoader classLoader, ClassLoader confClassLoader) {
        if (confClassLoader != null && confClassLoader != classLoader) {
            this.loadProperties(this.getResources("META-INF/drools.default." + confFileName, confClassLoader), this.defaultProps, confClassLoader);
            this.loadProperties(this.getResources("/META-INF/drools.default." + confFileName, confClassLoader), this.defaultProps, confClassLoader);
        }
    }

    private void loadPropertiesFromClassLoader(String confFileName, ClassLoader classLoader, ClassLoader confClassLoader) {
        if (confClassLoader != null && confClassLoader != classLoader) {
            this.loadProperties(this.getResources("META-INF/drools." + confFileName, confClassLoader), this.props, confClassLoader);
            this.loadProperties(this.getResources("/META-INF/drools." + confFileName, confClassLoader), this.props, confClassLoader);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.props = (List)in.readObject();
        this.defaultProps = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.props);
        out.writeObject(this.defaultProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration<URL> getResources(String name, ClassLoader classLoader) {
        if (CACHE_ENABLED) {
            CacheKey cacheKey = new CacheKey(name, classLoader);
            List<URL> urlList = resourceUrlCache.get(cacheKey);
            if (urlList == null) {
                Enumeration<URL> resources = null;
                try {
                    resources = classLoader.getResources(name);
                }
                catch (IOException e) {
                    logger.error("error", (Throwable)e);
                }
                Map<CacheKey, List<URL>> map = resourceUrlCache;
                synchronized (map) {
                    resourceUrlCache.put(cacheKey, Collections.list(resources));
                }
                return resources;
            }
            return Collections.enumeration(urlList);
        }
        Enumeration<URL> enumeration = null;
        try {
            enumeration = classLoader.getResources(name);
        }
        catch (IOException e) {
            logger.error("error", (Throwable)e);
        }
        return enumeration;
    }

    public void addProperties(Properties properties) {
        this.props.add(0, properties);
    }

    public String getProperty(String key, String defaultValue) {
        String value;
        block2: {
            Properties props;
            value = null;
            Iterator<Properties> i$ = this.props.iterator();
            while (i$.hasNext() && (value = (props = i$.next()).getProperty(key)) == null) {
            }
            if (value != null) break block2;
            i$ = this.defaultProps.iterator();
            while (i$.hasNext() && (value = (props = i$.next()).getProperty(key)) == null) {
            }
        }
        return value != null ? value : defaultValue;
    }

    public void mapStartsWith(Map<String, String> map, String startsWith, boolean includeSubProperties) {
        for (Properties props : this.props) {
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
        for (Properties props : this.defaultProps) {
            this.mapStartsWith(map, props, startsWith, includeSubProperties);
        }
    }

    private void mapStartsWith(Map<String, String> map, Properties properties, String startsWith, boolean includeSubProperties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(startsWith) || !includeSubProperties && key.substring(startsWith.length() + 1).indexOf(46) > 0 || map.containsKey(key)) continue;
            map.put(key, properties.getProperty(key));
        }
    }

    private void loadProperties(Enumeration<URL> enumeration, List<Properties> chain, ClassLoader classLoader) {
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL url = enumeration.nextElement();
            this.loadProperties(url, chain);
        }
    }

    private void loadProperties(String fileName, List<Properties> chain) {
        File file;
        if (fileName != null && (file = new File(fileName)) != null && file.exists()) {
            try {
                this.loadProperties(file.toURL(), chain);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("file.toURL() failed for " + fileName + " properties value '" + file + "'");
            }
        }
    }

    private void loadProperties(URL confURL, List<Properties> chain) {
        if (confURL == null) {
            return;
        }
        try {
            Properties properties = new Properties();
            InputStream is = confURL.openStream();
            properties.load(is);
            is.close();
            chain.add(properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class CacheKey {
        private String confFileName;
        private ClassLoader classLoader;

        CacheKey(String confFileName, ClassLoader classLoader) {
            this.confFileName = confFileName;
            this.classLoader = classLoader;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.classLoader == null ? 0 : this.classLoader.hashCode());
            result = 31 * result + (this.confFileName == null ? 0 : this.confFileName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.classLoader == null ? other.classLoader != null : !this.classLoader.equals(other.classLoader)) {
                return false;
            }
            return !(this.confFileName == null ? other.confFileName != null : !this.confFileName.equals(other.confFileName));
        }

        public String toString() {
            return "CacheKey [confFileName=" + this.confFileName + ", classLoader=" + this.classLoader + "]";
        }
    }
}

