/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablelong;

import java.util.Arrays;
import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;

public final class BendableLongScore
extends AbstractScore<BendableLongScore>
implements FeasibilityScore<BendableLongScore> {
    private final long[] hardScores;
    private final long[] softScores;

    public static BendableLongScore parseScore(int hardLevelsSize, int softLevelsSize, String scoreString) {
        int i;
        int levelsSize = hardLevelsSize + softLevelsSize;
        String[] levelStrings = BendableLongScore.parseLevelStrings(BendableLongScore.class, scoreString, levelsSize);
        long[] hardScores = new long[hardLevelsSize];
        long[] softScores = new long[softLevelsSize];
        for (i = 0; i < hardScores.length; ++i) {
            hardScores[i] = BendableLongScore.parseLevelAsLong(BendableLongScore.class, scoreString, levelStrings[i]);
        }
        for (i = 0; i < softScores.length; ++i) {
            softScores[i] = BendableLongScore.parseLevelAsLong(BendableLongScore.class, scoreString, levelStrings[hardScores.length + i]);
        }
        return BendableLongScore.valueOf(hardScores, softScores);
    }

    public static BendableLongScore valueOf(long[] hardScores, long[] softScores) {
        return new BendableLongScore(hardScores, softScores);
    }

    private BendableLongScore() {
        this.hardScores = null;
        this.softScores = null;
    }

    protected BendableLongScore(long[] hardScores, long[] softScores) {
        this.hardScores = hardScores;
        this.softScores = softScores;
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public long getHardScore(int index) {
        return this.hardScores[index];
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public long getSoftScore(int index) {
        return this.softScores[index];
    }

    public int getLevelsSize() {
        return this.hardScores.length + this.softScores.length;
    }

    public long getHardOrSoftScore(int index) {
        if (index < this.hardScores.length) {
            return this.hardScores[index];
        }
        return this.softScores[index - this.hardScores.length];
    }

    @Override
    public boolean isFeasible() {
        for (long hardScore : this.hardScores) {
            if (hardScore > 0L) {
                return true;
            }
            if (hardScore >= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public BendableLongScore add(BendableLongScore augment) {
        int i;
        this.validateCompatible(augment);
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] + augment.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] + augment.getSoftScore(i);
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore subtract(BendableLongScore subtrahend) {
        int i;
        this.validateCompatible(subtrahend);
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] - subtrahend.getHardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] - subtrahend.getSoftScore(i);
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore multiply(double multiplicand) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor((double)this.hardScores[i] * multiplicand);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor((double)this.softScores[i] * multiplicand);
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore divide(double divisor) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor((double)this.hardScores[i] / divisor);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor((double)this.softScores[i] / divisor);
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore power(double exponent) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor(Math.pow(this.hardScores[i], exponent));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor(Math.pow(this.softScores[i], exponent));
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public BendableLongScore negate() {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = -this.hardScores[i];
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = -this.softScores[i];
        }
        return new BendableLongScore(newHardScores, newSoftScores);
    }

    @Override
    public Number[] toLevelNumbers() {
        int i;
        Number[] levelNumbers = new Number[this.hardScores.length + this.softScores.length];
        for (i = 0; i < this.hardScores.length; ++i) {
            levelNumbers[i] = this.hardScores[i];
        }
        for (i = 0; i < this.softScores.length; ++i) {
            levelNumbers[this.hardScores.length + i] = this.softScores[i];
        }
        return levelNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BendableLongScore) {
            int i;
            BendableLongScore other = (BendableLongScore)o;
            if (this.getHardLevelsSize() != other.getHardLevelsSize() || this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
                return false;
            }
            for (i = 0; i < this.hardScores.length; ++i) {
                if (this.hardScores[i] == other.getHardScore(i)) continue;
                return false;
            }
            for (i = 0; i < this.softScores.length; ++i) {
                if (this.softScores[i] == other.getSoftScore(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.hardScores);
        result = 31 * result + Arrays.hashCode(this.softScores);
        return result;
    }

    @Override
    public int compareTo(BendableLongScore other) {
        int i;
        this.validateCompatible(other);
        for (i = 0; i < this.hardScores.length; ++i) {
            if (this.hardScores[i] == other.getHardScore(i)) continue;
            if (this.hardScores[i] < other.getHardScore(i)) {
                return -1;
            }
            return 1;
        }
        for (i = 0; i < this.softScores.length; ++i) {
            if (this.softScores[i] == other.getSoftScore(i)) continue;
            if (this.softScores[i] < other.getSoftScore(i)) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder((this.hardScores.length + this.softScores.length) * 4 + 1);
        boolean first = true;
        for (long hardScore : this.hardScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(hardScore);
        }
        for (long softScore : this.softScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(softScore);
        }
        return s.toString();
    }

    public void validateCompatible(BendableLongScore other) {
        if (this.getHardLevelsSize() != other.getHardLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with hardScoreSize (" + this.getHardLevelsSize() + ") is not compatible with the other score (" + other + ") with hardScoreSize (" + other.getHardLevelsSize() + ").");
        }
        if (this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with softScoreSize (" + this.getSoftLevelsSize() + ") is not compatible with the other score (" + other + ") with softScoreSize (" + other.getSoftLevelsSize() + ").");
        }
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        if (!(otherScore instanceof BendableLongScore)) {
            return false;
        }
        BendableLongScore otherBendableScore = (BendableLongScore)otherScore;
        return this.hardScores.length == otherBendableScore.hardScores.length && this.softScores.length == otherBendableScore.softScores.length;
    }
}

