/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.solver.event;

import java.util.EventObject;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;

public class BestSolutionChangedEvent<Solution_ extends Solution>
extends EventObject {
    private final Solver<Solution_> solver;
    private final long timeMillisSpent;
    private final Solution_ newBestSolution;
    private final int newUninitializedVariableCount;

    public BestSolutionChangedEvent(Solver<Solution_> solver, long timeMillisSpent, Solution_ newBestSolution, int newUninitializedVariableCount) {
        super(solver);
        this.solver = solver;
        this.timeMillisSpent = timeMillisSpent;
        this.newBestSolution = newBestSolution;
        this.newUninitializedVariableCount = newUninitializedVariableCount;
    }

    public long getTimeMillisSpent() {
        return this.timeMillisSpent;
    }

    public Solution_ getNewBestSolution() {
        return this.newBestSolution;
    }

    public boolean isEveryProblemFactChangeProcessed() {
        return this.solver.isEveryProblemFactChangeProcessed();
    }

    public boolean isNewBestSolutionInitialized() {
        return this.newUninitializedVariableCount == 0;
    }
}

