/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.acceptor;

import java.util.Arrays;
import java.util.List;
import org.optaplanner.core.impl.localsearch.decider.acceptor.AbstractAcceptor;
import org.optaplanner.core.impl.localsearch.decider.acceptor.Acceptor;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class CompositeAcceptor
extends AbstractAcceptor {
    protected final List<Acceptor> acceptorList;

    public CompositeAcceptor(List<Acceptor> acceptorList) {
        this.acceptorList = acceptorList;
    }

    public CompositeAcceptor(Acceptor ... acceptors) {
        this(Arrays.asList(acceptors));
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.solvingStarted(solverScope);
        }
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope phaseScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.phaseStarted(phaseScope);
        }
    }

    @Override
    public void stepStarted(LocalSearchStepScope stepScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.stepStarted(stepScope);
        }
    }

    @Override
    public boolean isAccepted(LocalSearchMoveScope moveScope) {
        for (Acceptor acceptor : this.acceptorList) {
            boolean accepted = acceptor.isAccepted(moveScope);
            if (accepted) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stepEnded(LocalSearchStepScope stepScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.stepEnded(stepScope);
        }
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope phaseScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.phaseEnded(phaseScope);
        }
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.solvingEnded(solverScope);
        }
    }
}

