/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase.scope;

import java.util.List;
import java.util.Random;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhaseScope {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final DefaultSolverScope solverScope;
    protected long startingSystemTimeMillis;
    protected Score startingScore;
    protected int bestSolutionStepIndex;

    public AbstractPhaseScope(DefaultSolverScope solverScope) {
        this.solverScope = solverScope;
    }

    public DefaultSolverScope getSolverScope() {
        return this.solverScope;
    }

    public long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public Score getStartingScore() {
        return this.startingScore;
    }

    public int getBestSolutionStepIndex() {
        return this.bestSolutionStepIndex;
    }

    public void setBestSolutionStepIndex(int bestSolutionStepIndex) {
        this.bestSolutionStepIndex = bestSolutionStepIndex;
    }

    public abstract AbstractStepScope getLastCompletedStepScope();

    public void reset() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.bestSolutionStepIndex = -1;
        this.startingScore = this.solverScope.calculateScore();
        if (this.getLastCompletedStepScope().getStepIndex() < 0) {
            this.getLastCompletedStepScope().setScore(this.startingScore);
        }
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solverScope.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.solverScope.getScoreDefinition();
    }

    public long calculateSolverTimeMillisSpent() {
        return this.solverScope.calculateTimeMillisSpent();
    }

    public long calculatePhaseTimeMillisSpent() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public InnerScoreDirector getScoreDirector() {
        return this.solverScope.getScoreDirector();
    }

    public Solution getWorkingSolution() {
        return this.solverScope.getWorkingSolution();
    }

    public int getWorkingEntityCount() {
        return this.solverScope.getWorkingEntityCount();
    }

    public List<Object> getWorkingEntityList() {
        return this.solverScope.getWorkingEntityList();
    }

    public int getWorkingValueCount() {
        return this.solverScope.getWorkingValueCount();
    }

    public Score calculateScore() {
        return this.solverScope.calculateScore();
    }

    public void assertExpectedWorkingScore(Score expectedWorkingScore, Object completedAction) {
        this.solverScope.assertExpectedWorkingScore(expectedWorkingScore, completedAction);
    }

    public void assertWorkingScoreFromScratch(Score workingScore, Object completedAction) {
        this.solverScope.assertWorkingScoreFromScratch(workingScore, completedAction);
    }

    public void assertExpectedUndoMoveScore(Move move, Move undoMove, Score beforeMoveScore) {
        Score undoScore = this.calculateScore();
        if (!undoScore.equals(beforeMoveScore)) {
            this.logger.trace("        Corruption detected. Diagnosing...");
            String undoMoveString = "Undo(" + move + ")";
            this.getScoreDirector().assertWorkingScoreFromScratch(undoScore, undoMoveString);
            this.getScoreDirector().assertShadowVariablesAreNotStale(undoScore, undoMoveString);
            throw new IllegalStateException("UndoMove corruption: the beforeMoveScore (" + beforeMoveScore + ") is not the undoScore (" + undoScore + ") which is the uncorruptedScore (" + undoScore + ") of the workingSolution.\n" + "  1) Enable EnvironmentMode " + (Object)((Object)EnvironmentMode.FULL_ASSERT) + " (if you haven't already) to fail-faster in case there's a score corruption.\n" + "  2) Check the Move.createUndoMove(...) method of the moveClass (" + move.getClass() + ")." + " The move (" + move + ") might have a corrupted undoMove (" + undoMoveString + ").\n" + "  3) Check your custom " + VariableListener.class.getSimpleName() + "s (if you have any)" + " for shadow variables that are used by the score constraints with a different score weight" + " between the beforeMoveScore (" + beforeMoveScore + ") and the undoScore (" + undoScore + ").");
        }
    }

    public Random getWorkingRandom() {
        return this.solverScope.getWorkingRandom();
    }

    public boolean isBestSolutionInitialized() {
        return this.solverScope.isBestSolutionInitialized();
    }

    public Score getBestScore() {
        return this.solverScope.getBestScore();
    }

    public String getBestScoreWithUninitializedPrefix() {
        return this.solverScope.getBestScoreWithUninitializedPrefix();
    }

    public long getPhaseBestSolutionTimeMillis() {
        long bestSolutionTimeMillis = this.solverScope.getBestSolutionTimeMillis();
        if (bestSolutionTimeMillis < this.startingSystemTimeMillis) {
            bestSolutionTimeMillis = this.startingSystemTimeMillis;
        }
        return bestSolutionTimeMillis;
    }

    public int getNextStepIndex() {
        return this.getLastCompletedStepScope().getStepIndex() + 1;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

