/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScoreHolder;
import org.optaplanner.core.impl.score.definition.AbstractBendableScoreDefinition;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class BendableBigDecimalScoreDefinition
extends AbstractBendableScoreDefinition<BendableBigDecimalScore> {
    public BendableBigDecimalScoreDefinition(int hardLevelsSize, int softLevelsSize) {
        super(hardLevelsSize, softLevelsSize);
    }

    @Override
    public Class<BendableBigDecimalScore> getScoreClass() {
        return BendableBigDecimalScore.class;
    }

    @Override
    public BendableBigDecimalScore parseScore(String scoreString) {
        return BendableBigDecimalScore.parseScore(this.hardLevelsSize, this.softLevelsSize, scoreString);
    }

    @Override
    public BendableBigDecimalScore fromLevelNumbers(Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        BigDecimal[] hardScores = new BigDecimal[this.hardLevelsSize];
        for (int i = 0; i < this.hardLevelsSize; ++i) {
            hardScores[i] = (BigDecimal)levelNumbers[i];
        }
        BigDecimal[] softScores = new BigDecimal[this.softLevelsSize];
        for (int i = 0; i < this.softLevelsSize; ++i) {
            softScores[i] = (BigDecimal)levelNumbers[this.hardLevelsSize + i];
        }
        return BendableBigDecimalScore.valueOf(hardScores, softScores);
    }

    public BendableBigDecimalScore createScore(BigDecimal ... scores) {
        int levelsSize = this.hardLevelsSize + this.softLevelsSize;
        if (scores.length != levelsSize) {
            throw new IllegalArgumentException("The scores (" + Arrays.toString(scores) + ")'s length (" + scores.length + ") is not levelsSize (" + levelsSize + ").");
        }
        return BendableBigDecimalScore.valueOf(Arrays.copyOfRange(scores, 0, this.hardLevelsSize), Arrays.copyOfRange(scores, this.hardLevelsSize, levelsSize));
    }

    @Override
    public BendableBigDecimalScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new BendableBigDecimalScoreHolder(constraintMatchEnabled, this.hardLevelsSize, this.softLevelsSize);
    }

    @Override
    public BendableBigDecimalScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, BendableBigDecimalScore score) {
        throw new UnsupportedOperationException("PLANNER-232: BigDecimalScore does not support bounds because a BigDecimal cannot represent infinity.");
    }

    @Override
    public BendableBigDecimalScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, BendableBigDecimalScore score) {
        throw new UnsupportedOperationException("PLANNER-232: BigDecimalScore does not support bounds because a BigDecimal cannot represent infinity.");
    }
}

