/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.graph.AbstractDirectedNodeConnections;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class DirectedMultiNodeConnections<N, E>
extends AbstractDirectedNodeConnections<N, E> {
    private transient Reference<Multiset<N>> predecessorsReference;
    private transient Reference<Multiset<N>> successorsReference;

    private DirectedMultiNodeConnections(Map<E, N> inEdges, Map<E, N> outEdges) {
        super(inEdges, outEdges);
    }

    static <N, E> DirectedMultiNodeConnections<N, E> of() {
        return new DirectedMultiNodeConnections(Maps.newHashMapWithExpectedSize(11), Maps.newHashMapWithExpectedSize(11));
    }

    static <N, E> DirectedMultiNodeConnections<N, E> ofImmutable(Map<E, N> inEdges, Map<E, N> outEdges) {
        return new DirectedMultiNodeConnections<N, E>(ImmutableMap.copyOf(inEdges), ImmutableMap.copyOf(outEdges));
    }

    @Override
    public Set<N> predecessors() {
        Multiset<N> predecessors = DirectedMultiNodeConnections.getReference(this.predecessorsReference);
        if (predecessors == null) {
            predecessors = HashMultiset.create(this.inEdgeMap.values());
            this.predecessorsReference = new SoftReference<Multiset<N>>(predecessors);
        }
        return Collections.unmodifiableSet(predecessors.elementSet());
    }

    @Override
    public Set<N> successors() {
        Multiset<N> successors = DirectedMultiNodeConnections.getReference(this.successorsReference);
        if (successors == null) {
            successors = HashMultiset.create(this.outEdgeMap.values());
            this.successorsReference = new SoftReference<Multiset<N>>(successors);
        }
        return Collections.unmodifiableSet(successors.elementSet());
    }

    @Override
    public Set<E> edgesConnecting(final Object node) {
        return Collections.unmodifiableSet(Maps.filterEntries(this.outEdgeMap, new Predicate<Map.Entry<E, N>>(){

            @Override
            public boolean apply(Map.Entry<E, N> entry) {
                return entry.getValue().equals(node);
            }
        }).keySet());
    }

    @Override
    public N removeInEdge(Object edge) {
        Multiset<N> predecessors;
        Object node = super.removeInEdge(edge);
        if (node != null && (predecessors = DirectedMultiNodeConnections.getReference(this.predecessorsReference)) != null) {
            Preconditions.checkState(predecessors.remove(node));
        }
        return node;
    }

    @Override
    public N removeOutEdge(Object edge) {
        Multiset<N> successors;
        Object node = super.removeOutEdge(edge);
        if (node != null && (successors = DirectedMultiNodeConnections.getReference(this.successorsReference)) != null) {
            Preconditions.checkState(successors.remove(node));
        }
        return node;
    }

    @Override
    public boolean addInEdge(E edge, N node) {
        if (super.addInEdge(edge, node)) {
            Multiset<N> predecessors = DirectedMultiNodeConnections.getReference(this.predecessorsReference);
            if (predecessors != null) {
                Preconditions.checkState(predecessors.add(node));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addOutEdge(E edge, N node) {
        if (super.addOutEdge(edge, node)) {
            Multiset<N> successors = DirectedMultiNodeConnections.getReference(this.successorsReference);
            if (successors != null) {
                Preconditions.checkState(successors.add(node));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static <T> T getReference(@Nullable Reference<T> reference) {
        if (reference == null) {
            return null;
        }
        return reference.get();
    }
}

