/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.graph.AbstractConfigurableNetwork;
import com.google.common.graph.DirectedMultiNodeConnections;
import com.google.common.graph.DirectedNodeConnections;
import com.google.common.graph.Graphs;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NodeConnections;
import com.google.common.graph.UndirectedMultiNodeConnections;
import com.google.common.graph.UndirectedNodeConnections;
import java.util.Map;
import java.util.Set;

public final class ImmutableNetwork<N, E>
extends AbstractConfigurableNetwork<N, E> {
    private ImmutableNetwork(Network<N, E> graph) {
        super(NetworkBuilder.from(graph), ImmutableNetwork.getNodeConnections(graph), ImmutableNetwork.getEdgeToReferenceNode(graph));
    }

    public static <N, E> ImmutableNetwork<N, E> copyOf(Network<N, E> graph) {
        return graph instanceof ImmutableNetwork ? (ImmutableNetwork<N, E>)graph : new ImmutableNetwork<N, E>(graph);
    }

    @Deprecated
    public static <N, E> ImmutableNetwork<N, E> copyOf(ImmutableNetwork<N, E> graph) {
        return Preconditions.checkNotNull(graph);
    }

    @Override
    public Set<E> edgesConnecting(Object node1, Object node2) {
        return ImmutableSet.copyOf(super.edgesConnecting(node1, node2));
    }

    private static <N, E> Map<N, NodeConnections<N, E>> getNodeConnections(Network<N, E> graph) {
        ImmutableMap.Builder nodeConnections = ImmutableMap.builder();
        for (Object node : graph.nodes()) {
            nodeConnections.put(node, ImmutableNetwork.nodeConnectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N, E> Map<E, N> getEdgeToReferenceNode(Network<N, E> graph) {
        ImmutableMap.Builder<E, N> edgeToReferenceNode = ImmutableMap.builder();
        for (E edge : graph.edges()) {
            edgeToReferenceNode.put(edge, graph.incidentNodes(edge).iterator().next());
        }
        return edgeToReferenceNode.build();
    }

    private static <N, E> NodeConnections<N, E> nodeConnectionsOf(Network<N, E> graph, N node) {
        if (graph.isDirected()) {
            Map<E, N> inEdgeMap = Maps.asMap(graph.inEdges(node), ImmutableNetwork.sourceNodeFn(graph));
            Map<E, N> outEdgeMap = Maps.asMap(graph.outEdges(node), ImmutableNetwork.targetNodeFn(graph));
            return graph.allowsParallelEdges() ? DirectedMultiNodeConnections.ofImmutable(inEdgeMap, outEdgeMap) : DirectedNodeConnections.ofImmutable(inEdgeMap, outEdgeMap);
        }
        Map<E, N> incidentEdgeMap = Maps.asMap(graph.incidentEdges(node), ImmutableNetwork.oppositeNodeFn(graph, node));
        return graph.allowsParallelEdges() ? UndirectedMultiNodeConnections.ofImmutable(incidentEdgeMap) : UndirectedNodeConnections.ofImmutable(incidentEdgeMap);
    }

    private static <N, E> Function<E, N> sourceNodeFn(final Network<N, E> graph) {
        return new Function<E, N>(){

            @Override
            public N apply(E edge) {
                return graph.source(edge);
            }
        };
    }

    private static <N, E> Function<E, N> targetNodeFn(final Network<N, E> graph) {
        return new Function<E, N>(){

            @Override
            public N apply(E edge) {
                return graph.target(edge);
            }
        };
    }

    private static <N, E> Function<E, N> oppositeNodeFn(final Network<N, E> graph, final N node) {
        return new Function<E, N>(){

            @Override
            public N apply(E edge) {
                return Graphs.oppositeNode(graph, edge, node);
            }
        };
    }
}

