/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.solver.move.factory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveIteratorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.solver.move.CheapTimePillarSlideMove;

public class CheapTimePillarSlideMoveIteratorFactory
implements MoveIteratorFactory<CheapTimeSolution> {
    public long getSize(ScoreDirector<CheapTimeSolution> scoreDirector) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Move> createOriginalMoveIterator(ScoreDirector<CheapTimeSolution> scoreDirector) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Move> createRandomMoveIterator(ScoreDirector<CheapTimeSolution> scoreDirector, Random workingRandom) {
        CheapTimeSolution cheapTimeSolution = (CheapTimeSolution)scoreDirector.getWorkingSolution();
        LinkedHashMap<Machine, ArrayList<TaskAssignment>> positivePillarMap = new LinkedHashMap<Machine, ArrayList<TaskAssignment>>(cheapTimeSolution.getGlobalPeriodRangeTo());
        LinkedHashMap<Machine, ArrayList<TaskAssignment>> negativePillarMap = new LinkedHashMap<Machine, ArrayList<TaskAssignment>>(cheapTimeSolution.getGlobalPeriodRangeTo());
        List<TaskAssignment> taskAssignmentList = cheapTimeSolution.getTaskAssignmentList();
        int pillarCapacity = taskAssignmentList.size() * 2 / cheapTimeSolution.getMachineList().size() + 1;
        for (TaskAssignment taskAssignment : taskAssignmentList) {
            List<TaskAssignment> pillar;
            Machine machine = taskAssignment.getMachine();
            Task task = taskAssignment.getTask();
            Integer startPeriod = taskAssignment.getStartPeriod();
            if (startPeriod == null) continue;
            if (startPeriod < task.getStartPeriodRangeTo() - 1) {
                pillar = (ArrayList<TaskAssignment>)positivePillarMap.get(machine);
                if (pillar == null) {
                    pillar = new ArrayList<TaskAssignment>(pillarCapacity);
                    positivePillarMap.put(machine, (ArrayList<TaskAssignment>)pillar);
                }
                pillar.add(taskAssignment);
            }
            if (startPeriod <= task.getStartPeriodRangeFrom()) continue;
            pillar = (List)negativePillarMap.get(machine);
            if (pillar == null) {
                pillar = new ArrayList(pillarCapacity);
                negativePillarMap.put(machine, (ArrayList<TaskAssignment>)pillar);
            }
            pillar.add(taskAssignment);
        }
        ArrayList<List<TaskAssignment>> positivePillarList = new ArrayList<List<TaskAssignment>>(positivePillarMap.size());
        for (List pillar : positivePillarMap.values()) {
            if (pillar.size() <= 1) continue;
            positivePillarList.add(pillar);
        }
        ArrayList<List<TaskAssignment>> arrayList = new ArrayList<List<TaskAssignment>>(negativePillarMap.size());
        for (List pillar : negativePillarMap.values()) {
            if (pillar.size() <= 1) continue;
            arrayList.add(pillar);
        }
        return new RandomCheapTimePillarSlideMoveIterator(positivePillarList, arrayList, workingRandom);
    }

    private class RandomCheapTimePillarSlideMoveIterator
    implements Iterator<Move> {
        private final List<List<TaskAssignment>> positivePillarList;
        private final List<List<TaskAssignment>> negativePillarList;
        private final Random workingRandom;
        private final int totalSize;

        public RandomCheapTimePillarSlideMoveIterator(List<List<TaskAssignment>> positivePillarList, List<List<TaskAssignment>> negativePillarList, Random workingRandom) {
            this.positivePillarList = positivePillarList;
            this.negativePillarList = negativePillarList;
            this.workingRandom = workingRandom;
            this.totalSize = positivePillarList.size() + negativePillarList.size();
        }

        @Override
        public boolean hasNext() {
            return this.totalSize > 0;
        }

        @Override
        public Move next() {
            int listIndex = this.workingRandom.nextInt(this.totalSize);
            boolean positive = listIndex < this.positivePillarList.size();
            List<TaskAssignment> basePillar = positive ? this.positivePillarList.get(listIndex) : this.negativePillarList.get(listIndex - this.positivePillarList.size());
            int basePillarSize = basePillar.size();
            int subPillarSize = this.workingRandom.nextInt(basePillarSize);
            TaskAssignment[] sandboxPillar = basePillar.toArray(new TaskAssignment[0]);
            ArrayList<TaskAssignment> subPillar = new ArrayList<TaskAssignment>(subPillarSize);
            int minimumAbsDiff = Integer.MAX_VALUE;
            for (int i = 0; i < subPillarSize; ++i) {
                int absDiff;
                int index = i + this.workingRandom.nextInt(basePillarSize - i);
                TaskAssignment taskAssignment = sandboxPillar[index];
                Task task = taskAssignment.getTask();
                int n = absDiff = positive ? task.getStartPeriodRangeTo() - 1 - taskAssignment.getStartPeriod() : taskAssignment.getStartPeriod() - task.getStartPeriodRangeFrom();
                if (absDiff < minimumAbsDiff) {
                    minimumAbsDiff = absDiff;
                }
                subPillar.add(taskAssignment);
                sandboxPillar[index] = sandboxPillar[i];
            }
            int startPeriodDiff = 1 + this.workingRandom.nextInt(minimumAbsDiff);
            if (!positive) {
                startPeriodDiff = -startPeriodDiff;
            }
            return new CheapTimePillarSlideMove(subPillar, startPeriodDiff);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The optional operation remove() is not supported.");
        }
    }
}

