/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.domain.InstitutionParametrization;
import org.optaplanner.examples.examination.swingui.ExaminationPanel;

public class InstitutionParametrizationDialog
extends JDialog {
    protected final ExaminationPanel examinationPanel;
    private JSpinner twoInARowPenaltyField;
    private JSpinner twoInADayPenaltyField;
    private JSpinner periodSpreadLengthField;
    private JSpinner periodSpreadPenaltyField;
    private JSpinner mixedDurationPenaltyField;
    private JSpinner frontLoadLargeTopicSizeField;
    private JSpinner frontLoadLastPeriodSizeField;
    private JSpinner frontLoadPenaltyField;
    protected final AbstractAction saveAction;
    protected final AbstractAction cancelAction;

    public InstitutionParametrizationDialog(Frame owner, ExaminationPanel examinationPanel) {
        super(owner, "Edit institution score parametrization", true);
        this.examinationPanel = examinationPanel;
        JPanel contentPanel = new JPanel(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)this.createFormPanel(), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.saveAction = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstitutionParametrizationDialog.this.save();
            }
        };
        buttonPanel.add(new JButton(this.saveAction));
        this.cancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstitutionParametrizationDialog.this.setVisible(false);
            }
        };
        buttonPanel.add(new JButton(this.cancelAction));
        contentPanel.add((Component)buttonPanel, "South");
        this.setContentPane(contentPanel);
        this.pack();
    }

    private JPanel createFormPanel() {
        JPanel formPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        formPanel.add(new JLabel("2 exams in a row penalty"));
        this.twoInARowPenaltyField = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        formPanel.add(this.twoInARowPenaltyField);
        formPanel.add(new JLabel("2 exams in a day penalty"));
        this.twoInADayPenaltyField = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        formPanel.add(this.twoInADayPenaltyField);
        formPanel.add(new JLabel("Period spread length"));
        this.periodSpreadLengthField = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        formPanel.add(this.periodSpreadLengthField);
        formPanel.add(new JLabel("Period spread penalty"));
        this.periodSpreadPenaltyField = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        formPanel.add(this.periodSpreadPenaltyField);
        formPanel.add(new JLabel("Exams of mixed duration penalty"));
        this.mixedDurationPenaltyField = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        formPanel.add(this.mixedDurationPenaltyField);
        formPanel.add(new JLabel("Front load: large exam size"));
        this.frontLoadLargeTopicSizeField = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.frontLoadLargeTopicSizeField.setEnabled(false);
        formPanel.add(this.frontLoadLargeTopicSizeField);
        formPanel.add(new JLabel("Front load: last period size"));
        this.frontLoadLastPeriodSizeField = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.frontLoadLastPeriodSizeField.setEnabled(false);
        formPanel.add(this.frontLoadLastPeriodSizeField);
        formPanel.add(new JLabel("Front load: penalty"));
        this.frontLoadPenaltyField = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        formPanel.add(this.frontLoadPenaltyField);
        return formPanel;
    }

    public void setInstitutionParametrization(InstitutionParametrization institutionParametrization) {
        this.twoInARowPenaltyField.setValue(institutionParametrization.getTwoInARowPenalty());
        this.twoInADayPenaltyField.setValue(institutionParametrization.getTwoInADayPenalty());
        this.periodSpreadLengthField.setValue(institutionParametrization.getPeriodSpreadLength());
        this.periodSpreadPenaltyField.setValue(institutionParametrization.getPeriodSpreadPenalty());
        this.mixedDurationPenaltyField.setValue(institutionParametrization.getMixedDurationPenalty());
        this.frontLoadLargeTopicSizeField.setValue(institutionParametrization.getFrontLoadLargeTopicSize());
        this.frontLoadLastPeriodSizeField.setValue(institutionParametrization.getFrontLoadLastPeriodSize());
        this.frontLoadPenaltyField.setValue(institutionParametrization.getFrontLoadPenalty());
        this.setLocationRelativeTo(this.examinationPanel.getTopLevelAncestor());
    }

    private void save() {
        int twoInARowPenalty = (Integer)this.twoInARowPenaltyField.getValue();
        int twoInADayPenalty = (Integer)this.twoInADayPenaltyField.getValue();
        int periodSpreadLength = (Integer)this.periodSpreadLengthField.getValue();
        int periodSpreadPenalty = (Integer)this.periodSpreadPenaltyField.getValue();
        int mixedDurationPenalty = (Integer)this.mixedDurationPenaltyField.getValue();
        int frontLoadLargeTopicSize = (Integer)this.frontLoadLargeTopicSizeField.getValue();
        int frontLoadLastPeriodSize = (Integer)this.frontLoadLastPeriodSizeField.getValue();
        int frontLoadPenalty = (Integer)this.frontLoadPenaltyField.getValue();
        this.setVisible(false);
        this.examinationPanel.doProblemFactChange(scoreDirector -> {
            Examination examination = (Examination)scoreDirector.getWorkingSolution();
            InstitutionParametrization institutionParametrization = examination.getInstitutionParametrization();
            scoreDirector.beforeProblemFactChanged((Object)institutionParametrization);
            institutionParametrization.setTwoInARowPenalty(twoInARowPenalty);
            institutionParametrization.setTwoInADayPenalty(twoInADayPenalty);
            institutionParametrization.setPeriodSpreadLength(periodSpreadLength);
            institutionParametrization.setPeriodSpreadPenalty(periodSpreadPenalty);
            institutionParametrization.setMixedDurationPenalty(mixedDurationPenalty);
            institutionParametrization.setFrontLoadLargeTopicSize(frontLoadLargeTopicSize);
            institutionParametrization.setFrontLoadLastPeriodSize(frontLoadLastPeriodSize);
            institutionParametrization.setFrontLoadPenalty(frontLoadPenalty);
            scoreDirector.afterProblemFactChanged((Object)institutionParametrization);
        }, true);
    }
}

