/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.persistence;

import java.io.IOException;
import org.jdom.Content;
import org.jdom.Element;
import org.optaplanner.examples.common.persistence.AbstractXmlSolutionExporter;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;
import org.optaplanner.examples.nurserostering.domain.Shift;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.persistence.NurseRosteringDao;

public class NurseRosteringExporter
extends AbstractXmlSolutionExporter<NurseRoster> {
    public static void main(String[] args) {
        new NurseRosteringExporter().convertAll();
    }

    public NurseRosteringExporter() {
        super(new NurseRosteringDao());
    }

    @Override
    public AbstractXmlSolutionExporter.XmlOutputBuilder<NurseRoster> createXmlOutputBuilder() {
        return new NurseRosteringOutputBuilder();
    }

    public static class NurseRosteringOutputBuilder
    extends AbstractXmlSolutionExporter.XmlOutputBuilder<NurseRoster> {
        private NurseRoster nurseRoster;

        @Override
        public void setSolution(NurseRoster solution) {
            this.nurseRoster = solution;
        }

        @Override
        public void writeSolution() throws IOException {
            Element solutionElement = new Element("Solution");
            this.document.setRootElement(solutionElement);
            Element schedulingPeriodIDElement = new Element("SchedulingPeriodID");
            schedulingPeriodIDElement.setText(this.nurseRoster.getCode());
            solutionElement.addContent((Content)schedulingPeriodIDElement);
            Element competitorElement = new Element("Competitor");
            competitorElement.setText("Geoffrey De Smet with OptaPlanner");
            solutionElement.addContent((Content)competitorElement);
            Element softConstraintsPenaltyElement = new Element("SoftConstraintsPenalty");
            softConstraintsPenaltyElement.setText(Integer.toString(this.nurseRoster.getScore().getSoftScore()));
            solutionElement.addContent((Content)softConstraintsPenaltyElement);
            for (ShiftAssignment shiftAssignment : this.nurseRoster.getShiftAssignmentList()) {
                Shift shift = shiftAssignment.getShift();
                if (shift == null) continue;
                Element assignmentElement = new Element("Assignment");
                solutionElement.addContent((Content)assignmentElement);
                Element dateElement = new Element("Date");
                dateElement.setText(shift.getShiftDate().getDateString());
                assignmentElement.addContent((Content)dateElement);
                Element employeeElement = new Element("Employee");
                employeeElement.setText(shiftAssignment.getEmployee().getCode());
                assignmentElement.addContent((Content)employeeElement);
                Element shiftTypeElement = new Element("ShiftType");
                shiftTypeElement.setText(shift.getShiftType().getCode());
                assignmentElement.addContent((Content)shiftTypeElement);
            }
        }
    }
}

