/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.scrabble.domain.solver;

import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.scrabble.domain.ScrabbleCell;
import org.optaplanner.examples.scrabble.domain.ScrabbleSolution;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordAssignment;
import org.optaplanner.examples.scrabble.domain.ScrabbleWordDirection;

public class CellUpdatingVariableListener
implements VariableListener<ScrabbleWordAssignment> {
    public void beforeEntityAdded(ScoreDirector scoreDirector, ScrabbleWordAssignment wordAssignment) {
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, ScrabbleWordAssignment wordAssignment) {
        this.insertWord(scoreDirector, wordAssignment);
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, ScrabbleWordAssignment wordAssignment) {
        this.retractWord(scoreDirector, wordAssignment);
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, ScrabbleWordAssignment wordAssignment) {
        this.insertWord(scoreDirector, wordAssignment);
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, ScrabbleWordAssignment wordAssignment) {
        this.retractWord(scoreDirector, wordAssignment);
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, ScrabbleWordAssignment wordAssignment) {
    }

    private void insertWord(ScoreDirector scoreDirector, ScrabbleWordAssignment wordAssignment) {
        ScrabbleSolution solution = (ScrabbleSolution)scoreDirector.getWorkingSolution();
        ScrabbleCell startCell = wordAssignment.getStartCell();
        ScrabbleWordDirection direction = wordAssignment.getDirection();
        if (startCell != null && direction != null) {
            int x = startCell.getX();
            int y = startCell.getY();
            String word = wordAssignment.getWord();
            for (int i = 0; i < word.length(); ++i) {
                ScrabbleCell cell = solution.getCell(x, y);
                scoreDirector.beforeVariableChanged((Object)cell, "wordSet");
                scoreDirector.beforeVariableChanged((Object)cell, "characterCountMap");
                solution.getCell(x, y).insertWordAssignment(wordAssignment, word.charAt(i));
                scoreDirector.afterVariableChanged((Object)cell, "wordSet");
                scoreDirector.afterVariableChanged((Object)cell, "characterCountMap");
                switch (direction) {
                    case HORIZONTAL: {
                        ++x;
                        break;
                    }
                    case VERTICAL: {
                        ++y;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The direction (" + (Object)((Object)direction) + ") is not implemented.");
                    }
                }
                if (x >= solution.getGridWidth() || y >= solution.getGridHeight()) break;
            }
        }
    }

    private void retractWord(ScoreDirector scoreDirector, ScrabbleWordAssignment wordAssignment) {
        ScrabbleSolution solution = (ScrabbleSolution)scoreDirector.getWorkingSolution();
        ScrabbleCell startCell = wordAssignment.getStartCell();
        ScrabbleWordDirection direction = wordAssignment.getDirection();
        if (startCell != null && direction != null) {
            int x = startCell.getX();
            int y = startCell.getY();
            String word = wordAssignment.getWord();
            for (int i = 0; i < word.length(); ++i) {
                ScrabbleCell cell = solution.getCell(x, y);
                scoreDirector.beforeVariableChanged((Object)cell, "wordSet");
                scoreDirector.beforeVariableChanged((Object)cell, "characterCountMap");
                cell.retractWordAssignment(wordAssignment, word.charAt(i));
                scoreDirector.afterVariableChanged((Object)cell, "wordSet");
                scoreDirector.afterVariableChanged((Object)cell, "characterCountMap");
                switch (direction) {
                    case HORIZONTAL: {
                        ++x;
                        break;
                    }
                    case VERTICAL: {
                        ++y;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The direction (" + (Object)((Object)direction) + ") is not implemented.");
                    }
                }
                if (x >= solution.getGridWidth() || y >= solution.getGridHeight()) break;
            }
        }
    }
}

