/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.taskassigning.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.taskassigning.domain.Customer;
import org.optaplanner.examples.taskassigning.domain.Priority;
import org.optaplanner.examples.taskassigning.domain.Task;
import org.optaplanner.examples.taskassigning.domain.TaskAssigningSolution;
import org.optaplanner.examples.taskassigning.domain.TaskType;
import org.optaplanner.examples.taskassigning.swingui.TaskOverviewPanel;

public class TaskAssigningPanel
extends SolutionPanel<TaskAssigningSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/taskassigning/swingui/taskAssigningLogo.png";
    private TaskOverviewPanel taskOverviewPanel;
    private JSpinner consumeRateField;
    private AbstractAction consumeAction;
    private Timer consumeTimer;
    private JSpinner produceRateField;
    private AbstractAction produceAction;
    private Timer produceTimer;
    private int consumedDurationInSeconds = 0;
    private int previousConsumedDuration = 0;
    private int producedDurationInSeconds = 0;
    private int previousProducedDuration = 0;
    private volatile Random producingRandom;

    public TaskAssigningPanel() {
        this.setLayout(new BorderLayout());
        JPanel headerPanel = this.createHeaderPanel();
        this.add((Component)headerPanel, "North");
        this.taskOverviewPanel = new TaskOverviewPanel(this);
        this.add((Component)new JScrollPane(this.taskOverviewPanel), "Center");
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new GridLayout(1, 0));
        JPanel consumePanel = new JPanel(new FlowLayout(0));
        consumePanel.add(new JLabel("Consume rate:"));
        this.consumeRateField = new JSpinner(new SpinnerNumberModel(1000, 10, 3600, 10));
        consumePanel.add(this.consumeRateField);
        this.consumeTimer = new Timer(1000, e -> {
            this.consumedDurationInSeconds += ((Integer)this.consumeRateField.getValue()).intValue();
            this.consumeUpTo(this.consumedDurationInSeconds / 60);
            this.repaint();
        });
        this.consumeAction = new AbstractAction("Consume"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TaskAssigningPanel.this.consumeTimer.isRunning()) {
                    TaskAssigningPanel.this.consumeRateField.setEnabled(false);
                    TaskAssigningPanel.this.consumeTimer.start();
                } else {
                    TaskAssigningPanel.this.consumeRateField.setEnabled(true);
                    TaskAssigningPanel.this.consumeTimer.stop();
                }
            }
        };
        consumePanel.add(new JToggleButton(this.consumeAction));
        headerPanel.add(consumePanel);
        JPanel producePanel = new JPanel(new FlowLayout(0));
        producePanel.add(new JLabel("Produce rate:"));
        this.produceRateField = new JSpinner(new SpinnerNumberModel(1000, 10, 3600, 10));
        producePanel.add(this.produceRateField);
        this.produceTimer = new Timer(1000, e -> {
            this.producedDurationInSeconds += ((Integer)this.produceRateField.getValue()).intValue();
            this.produceUpTo(this.producedDurationInSeconds / 60);
            this.repaint();
        });
        this.produceAction = new AbstractAction("Produce"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TaskAssigningPanel.this.produceTimer.isRunning()) {
                    TaskAssigningPanel.this.produceRateField.setEnabled(false);
                    TaskAssigningPanel.this.produceTimer.start();
                } else {
                    TaskAssigningPanel.this.produceRateField.setEnabled(true);
                    TaskAssigningPanel.this.produceTimer.stop();
                }
            }
        };
        producePanel.add(new JToggleButton(this.produceAction));
        headerPanel.add(producePanel);
        return headerPanel;
    }

    public void consumeUpTo(int consumedDuration) {
        this.taskOverviewPanel.setConsumedDuration(consumedDuration);
        if (consumedDuration <= this.previousConsumedDuration) {
            return;
        }
        this.logger.debug("Scheduling consumption of all tasks up to {} minutes.", (Object)consumedDuration);
        this.previousConsumedDuration = consumedDuration;
        this.doProblemFactChange(scoreDirector -> {
            TaskAssigningSolution solution = (TaskAssigningSolution)scoreDirector.getWorkingSolution();
            for (Task task : solution.getTaskList()) {
                if (task.isLocked()) continue;
                if (task.getStartTime() != null && task.getStartTime() < consumedDuration) {
                    scoreDirector.beforeProblemFactChanged((Object)task);
                    task.setLocked(true);
                    scoreDirector.afterProblemFactChanged((Object)task);
                    this.logger.trace("Consumed task ({}).", (Object)task);
                    continue;
                }
                if (task.getReadyTime() >= consumedDuration) continue;
                scoreDirector.beforeProblemFactChanged((Object)task);
                task.setReadyTime(consumedDuration);
                scoreDirector.afterProblemFactChanged((Object)task);
            }
            scoreDirector.triggerVariableListeners();
        });
    }

    public void produceUpTo(int producedDuration) {
        if (producedDuration <= this.previousProducedDuration) {
            return;
        }
        int baseDurationBudgetPerEmployee = producedDuration - this.previousProducedDuration;
        if (baseDurationBudgetPerEmployee < 75) {
            return;
        }
        int newTaskCount = Math.max(1, ((TaskAssigningSolution)this.getSolution()).getEmployeeList().size() * baseDurationBudgetPerEmployee / 75);
        this.logger.debug("Scheduling production of {} new tasks.", (Object)newTaskCount);
        this.previousProducedDuration = producedDuration;
        int readyTime = this.previousConsumedDuration;
        this.doProblemFactChange(scoreDirector -> {
            TaskAssigningSolution solution = (TaskAssigningSolution)scoreDirector.getWorkingSolution();
            List<TaskType> taskTypeList = solution.getTaskTypeList();
            List<Customer> customerList = solution.getCustomerList();
            Priority[] priorities = Priority.values();
            List<Task> taskList = solution.getTaskList();
            for (int i = 0; i < newTaskCount; ++i) {
                Task task = new Task();
                TaskType taskType = taskTypeList.get(this.producingRandom.nextInt(taskTypeList.size()));
                long nextTaskId = 0L;
                int nextIndexInTaskType = 0;
                for (Task other : taskList) {
                    if (nextTaskId <= other.getId()) {
                        nextTaskId = other.getId() + 1L;
                    }
                    if (taskType != other.getTaskType() || nextIndexInTaskType > other.getIndexInTaskType()) continue;
                    nextIndexInTaskType = other.getIndexInTaskType() + 1;
                }
                task.setId(nextTaskId);
                task.setTaskType(taskType);
                task.setIndexInTaskType(nextIndexInTaskType);
                task.setCustomer(customerList.get(this.producingRandom.nextInt(customerList.size())));
                task.setReadyTime(readyTime);
                task.setPriority(priorities[this.producingRandom.nextInt(priorities.length)]);
                scoreDirector.beforeEntityAdded((Object)task);
                taskList.add(task);
                scoreDirector.afterEntityAdded((Object)task);
            }
            scoreDirector.triggerVariableListeners();
        });
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    @Override
    public void resetPanel(TaskAssigningSolution taskAssigningSolution) {
        this.consumedDurationInSeconds = 0;
        this.previousConsumedDuration = 0;
        this.producedDurationInSeconds = 0;
        this.previousProducedDuration = 0;
        this.producingRandom = new Random(0L);
        this.taskOverviewPanel.resetPanel(taskAssigningSolution);
        this.taskOverviewPanel.setConsumedDuration(this.consumedDurationInSeconds / 60);
    }

    @Override
    public void updatePanel(TaskAssigningSolution taskAssigningSolution) {
        this.taskOverviewPanel.resetPanel(taskAssigningSolution);
    }
}

