/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.timewindowed.solver;

import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;

public class ArrivalTimeUpdatingVariableListener
implements VariableListener<Customer> {
    public void beforeEntityAdded(ScoreDirector scoreDirector, Customer customer) {
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, Customer customer) {
        if (customer instanceof TimeWindowedCustomer) {
            this.updateArrivalTime(scoreDirector, (TimeWindowedCustomer)customer);
        }
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, Customer customer) {
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, Customer customer) {
        if (customer instanceof TimeWindowedCustomer) {
            this.updateArrivalTime(scoreDirector, (TimeWindowedCustomer)customer);
        }
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, Customer customer) {
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, Customer customer) {
    }

    protected void updateArrivalTime(ScoreDirector scoreDirector, TimeWindowedCustomer sourceCustomer) {
        TimeWindowedCustomer shadowCustomer;
        Standstill previousStandstill = sourceCustomer.getPreviousStandstill();
        Long departureTime = previousStandstill instanceof TimeWindowedCustomer ? ((TimeWindowedCustomer)previousStandstill).getDepartureTime() : null;
        Long arrivalTime = this.calculateArrivalTime(shadowCustomer, departureTime);
        for (shadowCustomer = sourceCustomer; shadowCustomer != null && !Objects.equals(shadowCustomer.getArrivalTime(), arrivalTime); shadowCustomer = shadowCustomer.getNextCustomer()) {
            scoreDirector.beforeVariableChanged((Object)shadowCustomer, "arrivalTime");
            shadowCustomer.setArrivalTime(arrivalTime);
            scoreDirector.afterVariableChanged((Object)shadowCustomer, "arrivalTime");
            departureTime = shadowCustomer.getDepartureTime();
            arrivalTime = this.calculateArrivalTime(shadowCustomer, departureTime);
        }
    }

    private Long calculateArrivalTime(TimeWindowedCustomer customer, Long previousDepartureTime) {
        if (customer == null || customer.getPreviousStandstill() == null) {
            return null;
        }
        if (previousDepartureTime == null) {
            return Math.max(customer.getReadyTime(), customer.getDistanceFromPreviousStandstill());
        }
        return previousDepartureTime + customer.getDistanceFromPreviousStandstill();
    }
}

