/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools;

import org.kie.api.KieBase;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Global;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drools.DroolsScoreDirector;

public class DroolsScoreDirectorFactory<Solution_>
extends AbstractScoreDirectorFactory<Solution_> {
    protected final KieContainer kieContainer;
    protected final String ksessionName;

    protected DroolsScoreDirectorFactory(KieBase kieBase) {
        this.kieContainer = null;
        this.ksessionName = null;
    }

    public DroolsScoreDirectorFactory(KieContainer kieContainer, String ksessionName) {
        this.kieContainer = kieContainer;
        this.ksessionName = ksessionName;
        KieSessionModel kieSessionModel = kieContainer.getKieSessionModel(ksessionName);
        if (kieSessionModel == null) {
            if (ksessionName == null) {
                throw new IllegalArgumentException("The kieContainer does not have a default ksession and the ksessionName (" + ksessionName + ") is not specified.");
            }
            throw new IllegalArgumentException("The kieContainer does not contain a ksessionName (" + ksessionName + ") with that name.");
        }
        if (kieSessionModel.getType() != KieSessionModel.KieSessionType.STATEFUL) {
            throw new IllegalStateException("The ksessionName (" + ksessionName + ") with type (" + kieSessionModel.getType() + ") is not stateful.\nStateless sessions are not allowed because they don't support incremental score calculation and are therefore exponentially slower.");
        }
        String kbaseName = kieSessionModel.getKieBaseModel().getName();
        KieBase kieBase = kieContainer.newKieBase(kbaseName, null);
        this.checkIfGlobalScoreHolderExists(kieBase);
    }

    protected void checkIfGlobalScoreHolderExists(KieBase kieBase) {
        boolean hasGlobalScoreHolder = false;
        block0: for (KiePackage kiePackage : kieBase.getKiePackages()) {
            for (Global global : kiePackage.getGlobalVariables()) {
                if (!"scoreHolder".equals(global.getName())) continue;
                hasGlobalScoreHolder = true;
                continue block0;
            }
        }
        if (!hasGlobalScoreHolder) {
            throw new IllegalArgumentException("The kieBase with kiePackages (" + kieBase.getKiePackages() + ") has no global field called " + "scoreHolder" + ".\nCheck if the rule files are found and if the global field is spelled correctly.");
        }
    }

    @Override
    public void setSolutionDescriptor(SolutionDescriptor<Solution_> solutionDescriptor) {
        super.setSolutionDescriptor(solutionDescriptor);
        solutionDescriptor.checkIfProblemFactsExist();
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public String getKsessionName() {
        return this.ksessionName;
    }

    @Override
    public DroolsScoreDirector<Solution_> buildScoreDirector(boolean constraintMatchEnabledPreference) {
        return new DroolsScoreDirector(this, constraintMatchEnabledPreference);
    }

    public KieSession newKieSession() {
        return this.kieContainer.newKieSession(this.ksessionName);
    }
}

