/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.fluent.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.drools.core.command.ConversationContextManager;
import org.drools.core.command.RequestContextImpl;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.time.SessionPseudoClock;
import org.drools.core.world.impl.ContextManagerImpl;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.Context;
import org.kie.internal.command.ContextManager;
import org.kie.internal.fluent.Batch;
import org.kie.internal.fluent.Executable;

public class PseudoClockRunner {
    private PriorityQueue<Batch> queue = new PriorityQueue<Batch>(BatchSorter.instance);
    private Set<KieSession> ksessions = new HashSet<KieSession>();
    private final Map<String, Context> appContexts = new HashMap<String, Context>();
    private ConversationContextManager cvnManager = new ConversationContextManager();
    private long counter;
    private long startTime;

    public PseudoClockRunner() {
        this(System.currentTimeMillis());
    }

    public PseudoClockRunner(long startTime) {
        this.startTime = startTime;
    }

    public Map<String, Context> getAppContexts() {
        return this.appContexts;
    }

    public Context execute(Executable executable) {
        return this.execute(executable, this.createContext());
    }

    public Context execute(Executable executable, Context ctx) {
        for (Batch batch : executable.getBatches()) {
            if (batch.getDistance() == 0L) {
                this.executeBatch(batch, ctx);
                continue;
            }
            this.queue.add(batch);
        }
        while (!this.queue.isEmpty()) {
            Batch batch = (Batch)this.queue.remove();
            long timeNow = this.startTime + batch.getDistance();
            for (KieSession ksession : this.ksessions) {
                this.updateKieSessionTime(timeNow, batch.getDistance(), ksession);
            }
            for (Command cmd : batch.getCommands()) {
                Object returned = ((ExecutableCommand)cmd).execute(ctx);
                if (returned == null) continue;
                if (ctx instanceof RequestContextImpl) {
                    ((RequestContextImpl)ctx).setLastReturned(returned);
                }
                if (!(returned instanceof KieSession)) continue;
                KieSession ksession = (KieSession)returned;
                this.updateKieSessionTime(timeNow, batch.getDistance(), ksession);
                this.ksessions.add((KieSession)returned);
            }
        }
        return ctx;
    }

    private void executeBatch(Batch batch, Context ctx) {
        long timeNow = this.startTime;
        for (Command cmd : batch.getCommands()) {
            Object returned = ((ExecutableCommand)cmd).execute(ctx);
            if (returned == null) continue;
            if (ctx instanceof RequestContextImpl) {
                ((RequestContextImpl)ctx).setLastReturned(returned);
            }
            if (!(returned instanceof KieSession)) continue;
            KieSession ksession = (KieSession)returned;
            this.updateKieSessionTime(timeNow, 0L, ksession);
            this.ksessions.add((KieSession)returned);
        }
    }

    public RequestContextImpl createContext() {
        return new RequestContextImpl(this.counter++, (ContextManager)new ContextManagerImpl(this.appContexts), this.cvnManager);
    }

    private void updateKieSessionTime(long timeNow, long distance, KieSession ksession) {
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        if (clock.getCurrentTime() != timeNow) {
            long newTime = this.startTime + distance;
            long currentTime = clock.getCurrentTime();
            clock.advanceTime(newTime - currentTime, TimeUnit.MILLISECONDS);
        }
    }

    private static class BatchSorter
    implements Comparator<Batch> {
        public static BatchSorter instance = new BatchSorter();

        private BatchSorter() {
        }

        @Override
        public int compare(Batch o1, Batch o2) {
            if (o1.getDistance() > o2.getDistance()) {
                return 1;
            }
            if (o1.getDistance() < o2.getDistance()) {
                return -1;
            }
            return 0;
        }
    }
}

