/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.move;

import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.factory.MoveIteratorFactoryConfig;
import org.optaplanner.core.config.heuristic.selector.move.factory.MoveListFactoryConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.PillarChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.PillarSwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.KOptMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.SubChainChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.SubChainSwapMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.chained.TailChainSwapMoveSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.CachingMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.FilteringMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.ProbabilityMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.SelectedCountLimitMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.ShufflingMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.SortingMoveSelector;

@XStreamInclude(value={UnionMoveSelectorConfig.class, CartesianProductMoveSelectorConfig.class, ChangeMoveSelectorConfig.class, SwapMoveSelectorConfig.class, PillarChangeMoveSelectorConfig.class, PillarSwapMoveSelectorConfig.class, TailChainSwapMoveSelectorConfig.class, KOptMoveSelectorConfig.class, SubChainChangeMoveSelectorConfig.class, SubChainSwapMoveSelectorConfig.class, MoveListFactoryConfig.class, MoveIteratorFactoryConfig.class})
public abstract class MoveSelectorConfig<C extends MoveSelectorConfig>
extends SelectorConfig<C> {
    protected SelectionCacheType cacheType = null;
    protected SelectionOrder selectionOrder = null;
    @XStreamImplicit(itemFieldName="filterClass")
    protected List<Class<? extends SelectionFilter>> filterClassList = null;
    protected Class<? extends Comparator> sorterComparatorClass = null;
    protected Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = null;
    protected SelectionSorterOrder sorterOrder = null;
    protected Class<? extends SelectionSorter> sorterClass = null;
    protected Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = null;
    protected Long selectedCountLimit = null;
    private Double fixedProbabilityWeight = null;

    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public List<Class<? extends SelectionFilter>> getFilterClassList() {
        return this.filterClassList;
    }

    public void setFilterClassList(List<Class<? extends SelectionFilter>> filterClassList) {
        this.filterClassList = filterClassList;
    }

    public Class<? extends Comparator> getSorterComparatorClass() {
        return this.sorterComparatorClass;
    }

    public void setSorterComparatorClass(Class<? extends Comparator> sorterComparatorClass) {
        this.sorterComparatorClass = sorterComparatorClass;
    }

    public Class<? extends SelectionSorterWeightFactory> getSorterWeightFactoryClass() {
        return this.sorterWeightFactoryClass;
    }

    public void setSorterWeightFactoryClass(Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass) {
        this.sorterWeightFactoryClass = sorterWeightFactoryClass;
    }

    public SelectionSorterOrder getSorterOrder() {
        return this.sorterOrder;
    }

    public void setSorterOrder(SelectionSorterOrder sorterOrder) {
        this.sorterOrder = sorterOrder;
    }

    public Class<? extends SelectionSorter> getSorterClass() {
        return this.sorterClass;
    }

    public void setSorterClass(Class<? extends SelectionSorter> sorterClass) {
        this.sorterClass = sorterClass;
    }

    public Class<? extends SelectionProbabilityWeightFactory> getProbabilityWeightFactoryClass() {
        return this.probabilityWeightFactoryClass;
    }

    public void setProbabilityWeightFactoryClass(Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass) {
        this.probabilityWeightFactoryClass = probabilityWeightFactoryClass;
    }

    public Long getSelectedCountLimit() {
        return this.selectedCountLimit;
    }

    public void setSelectedCountLimit(Long selectedCountLimit) {
        this.selectedCountLimit = selectedCountLimit;
    }

    public Double getFixedProbabilityWeight() {
        return this.fixedProbabilityWeight;
    }

    public void setFixedProbabilityWeight(Double fixedProbabilityWeight) {
        this.fixedProbabilityWeight = fixedProbabilityWeight;
    }

    public MoveSelector buildMoveSelector(HeuristicConfigPolicy configPolicy, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        MoveSelectorConfig unfoldedMoveSelectorConfig = this.buildUnfoldedMoveSelectorConfig(configPolicy);
        if (unfoldedMoveSelectorConfig != null) {
            return unfoldedMoveSelectorConfig.buildMoveSelector(configPolicy, minimumCacheType, inheritedSelectionOrder);
        }
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(this.cacheType, minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(this.selectionOrder, inheritedSelectionOrder);
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        MoveSelector moveSelector = this.buildBaseMoveSelector(configPolicy, SelectionCacheType.max(minimumCacheType, resolvedCacheType), this.determineBaseRandomSelection(resolvedCacheType, resolvedSelectionOrder));
        moveSelector = this.applyFiltering(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        moveSelector = this.applySelectedLimit(resolvedCacheType, resolvedSelectionOrder, moveSelector);
        return moveSelector;
    }

    protected MoveSelectorConfig buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy configPolicy) {
        return null;
    }

    protected boolean determineBaseRandomSelection(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        switch (resolvedSelectionOrder) {
            case ORIGINAL: {
                return false;
            }
            case SORTED: 
            case SHUFFLED: 
            case PROBABILISTIC: {
                return false;
            }
            case RANDOM: {
                return resolvedCacheType.isNotCached() || this.isBaseInherentlyCached() && !this.hasFiltering();
            }
        }
        throw new IllegalStateException("The selectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") is not implemented.");
    }

    protected boolean isBaseInherentlyCached() {
        return false;
    }

    protected abstract MoveSelector buildBaseMoveSelector(HeuristicConfigPolicy var1, SelectionCacheType var2, boolean var3);

    private boolean hasFiltering() {
        return !ConfigUtils.isEmptyCollection(this.filterClassList);
    }

    private MoveSelector applyFiltering(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector moveSelector) {
        if (this.hasFiltering()) {
            ArrayList<SelectionFilter> filterList = new ArrayList<SelectionFilter>(this.filterClassList.size());
            for (Class<? extends SelectionFilter> filterClass : this.filterClassList) {
                filterList.add(ConfigUtils.newInstance(this, "filterClass", filterClass));
            }
            moveSelector = new FilteringMoveSelector(moveSelector, filterList);
        }
        return moveSelector;
    }

    private void validateSorting(SelectionOrder resolvedSelectionOrder) {
        if ((this.sorterComparatorClass != null || this.sorterWeightFactoryClass != null || this.sorterOrder != null || this.sorterClass != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") with sorterComparatorClass (" + this.sorterComparatorClass + ") and sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and sorterOrder (" + (Object)((Object)this.sorterOrder) + ") and sorterClass (" + this.sorterClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.SORTED) + ".");
        }
        if (this.sorterComparatorClass != null && this.sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ").");
        }
        if (this.sorterComparatorClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") has both a sorterComparatorClass (" + this.sorterComparatorClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterWeightFactoryClass != null && this.sorterClass != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") has both a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") and a sorterClass (" + this.sorterClass + ").");
        }
        if (this.sorterClass != null && this.sorterOrder != null) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") with sorterClass (" + this.sorterClass + ") has a non-null sorterOrder (" + (Object)((Object)this.sorterOrder) + ").");
        }
    }

    private MoveSelector applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector moveSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            SelectionSorter sorter;
            if (this.sorterComparatorClass != null) {
                Comparator sorterComparator = ConfigUtils.newInstance(this, "sorterComparatorClass", this.sorterComparatorClass);
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterWeightFactoryClass != null) {
                SelectionSorterWeightFactory sorterWeightFactory = ConfigUtils.newInstance(this, "sorterWeightFactoryClass", this.sorterWeightFactoryClass);
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(this.sorterOrder));
            } else if (this.sorterClass != null) {
                sorter = ConfigUtils.newInstance(this, "sorterClass", this.sorterClass);
            } else {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a sorterComparatorClass (" + this.sorterComparatorClass + ") or a sorterWeightFactoryClass (" + this.sorterWeightFactoryClass + ") or a sorterClass (" + this.sorterClass + ").");
            }
            moveSelector = new SortingMoveSelector(moveSelector, resolvedCacheType, sorter);
        }
        return moveSelector;
    }

    private void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (this.probabilityWeightFactoryClass != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") with probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.PROBABILISTIC) + ".");
        }
    }

    private MoveSelector applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector moveSelector) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (this.probabilityWeightFactoryClass == null) {
                throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") with resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") needs a probabilityWeightFactoryClass (" + this.probabilityWeightFactoryClass + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = ConfigUtils.newInstance(this, "probabilityWeightFactoryClass", this.probabilityWeightFactoryClass);
            moveSelector = new ProbabilityMoveSelector(moveSelector, resolvedCacheType, probabilityWeightFactory);
        }
        return moveSelector;
    }

    private MoveSelector applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector moveSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            moveSelector = new ShufflingMoveSelector(moveSelector, resolvedCacheType);
        }
        return moveSelector;
    }

    private MoveSelector applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector moveSelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(moveSelector.getCacheType()) > 0) {
            moveSelector = new CachingMoveSelector(moveSelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return moveSelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (this.selectedCountLimit != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The moveSelectorConfig (" + this + ") with selectedCountLimit (" + this.selectedCountLimit + ") has a minimumCacheType (" + (Object)((Object)minimumCacheType) + ") that is higher than " + (Object)((Object)SelectionCacheType.JUST_IN_TIME) + ".");
        }
    }

    private MoveSelector applySelectedLimit(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, MoveSelector moveSelector) {
        if (this.selectedCountLimit != null) {
            moveSelector = new SelectedCountLimitMoveSelector(moveSelector, this.selectedCountLimit);
        }
        return moveSelector;
    }

    @Override
    public void inherit(C inheritedConfig) {
        super.inherit(inheritedConfig);
        this.inheritCommon((MoveSelectorConfig)inheritedConfig);
    }

    public void inheritFolded(MoveSelectorConfig foldedConfig) {
        this.inheritCommon(foldedConfig);
    }

    private void inheritCommon(MoveSelectorConfig inheritedConfig) {
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.filterClassList = ConfigUtils.inheritOverwritableProperty(this.filterClassList, inheritedConfig.getFilterClassList());
        this.sorterComparatorClass = ConfigUtils.inheritOverwritableProperty(this.sorterComparatorClass, inheritedConfig.getSorterComparatorClass());
        this.sorterWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.sorterWeightFactoryClass, inheritedConfig.getSorterWeightFactoryClass());
        this.sorterOrder = ConfigUtils.inheritOverwritableProperty(this.sorterOrder, inheritedConfig.getSorterOrder());
        this.sorterClass = ConfigUtils.inheritOverwritableProperty(this.sorterClass, inheritedConfig.getSorterClass());
        this.probabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.probabilityWeightFactoryClass, inheritedConfig.getProbabilityWeightFactoryClass());
        this.selectedCountLimit = ConfigUtils.inheritOverwritableProperty(this.selectedCountLimit, inheritedConfig.getSelectedCountLimit());
        this.fixedProbabilityWeight = ConfigUtils.inheritOverwritableProperty(this.fixedProbabilityWeight, inheritedConfig.getFixedProbabilityWeight());
    }
}

