/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.partitionedsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.recaller.BestSolutionRecallerConfig;
import org.optaplanner.core.impl.partitionedsearch.PartitionSolver;
import org.optaplanner.core.impl.partitionedsearch.PartitionedSearchPhase;
import org.optaplanner.core.impl.partitionedsearch.partitioner.SolutionPartitioner;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;

public class DefaultPartitionedSearchPhase<Solution_>
extends AbstractPhase<Solution_>
implements PartitionedSearchPhase<Solution_> {
    protected ThreadPoolExecutor threadPoolExecutor;
    protected Integer activeThreadCount;
    protected SolutionPartitioner<Solution_> solutionPartitioner;
    protected List<PhaseConfig> phaseConfigList;
    protected HeuristicConfigPolicy configPolicy;

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setSolutionPartitioner(SolutionPartitioner<Solution_> solutionPartitioner) {
        this.solutionPartitioner = solutionPartitioner;
    }

    public void setPhaseConfigList(List<PhaseConfig> phaseConfigList) {
        this.phaseConfigList = phaseConfigList;
    }

    public void setConfigPolicy(HeuristicConfigPolicy configPolicy) {
        this.configPolicy = configPolicy;
    }

    @Override
    public String getPhaseTypeString() {
        return "Partitioned Search";
    }

    @Override
    public void solve(DefaultSolverScope<Solution_> solverScope) {
        List<Solution_> partList = this.solutionPartitioner.splitWorkingSolution(solverScope.getScoreDirector());
        int partCount = partList.size();
        if (this.threadPoolExecutor.getMaximumPoolSize() < partCount) {
            throw new IllegalStateException("The threadPoolExecutor's maximumPoolSize (" + this.threadPoolExecutor.getMaximumPoolSize() + ") is less than the partCount (" + partCount + "), so some partitions will starve.\nNormally this impossible because the threadPoolExecutor should be unbounded: Use activeThreadCount (" + this.activeThreadCount + ") instead to avoid CPU hogging and live locks.");
        }
        ArrayList<Future<Object>> futureList = new ArrayList<Future<Object>>(partCount);
        Semaphore activeThreadSemaphore = this.activeThreadCount == null ? null : new Semaphore(this.activeThreadCount);
        for (Solution_ Solution_ : partList) {
            PartitionSolver<Solution_> partitionSolver = this.buildPartitionSolver(activeThreadSemaphore, solverScope);
            Future<Object> future = this.threadPoolExecutor.submit(() -> partitionSolver.solve(part));
            futureList.add(future);
        }
        for (Future future : futureList) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public PartitionSolver<Solution_> buildPartitionSolver(Semaphore activeThreadSemaphore, DefaultSolverScope<Solution_> solverScope) {
        Termination partTermination = this.termination.createChildThreadTermination(solverScope, ChildThreadType.PART_THREAD);
        BestSolutionRecaller bestSolutionRecaller = new BestSolutionRecallerConfig().buildBestSolutionRecaller(this.configPolicy.getEnvironmentMode());
        ArrayList phaseList = new ArrayList(this.phaseConfigList.size());
        int partPhaseIndex = 0;
        for (PhaseConfig phaseConfig : this.phaseConfigList) {
            phaseList.add(phaseConfig.buildPhase(partPhaseIndex, this.configPolicy, bestSolutionRecaller, partTermination));
            ++partPhaseIndex;
        }
        DefaultSolverScope<Solution_> partSolverScope = solverScope.createChildThreadSolverScope(ChildThreadType.PART_THREAD);
        partSolverScope.setActiveThreadSemaphore(activeThreadSemaphore);
        return new PartitionSolver(partTermination, bestSolutionRecaller, phaseList, partSolverScope);
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }
}

