/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.TreeSet;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestGenTestWriter {
    private static final Logger logger = LoggerFactory.getLogger(TestGenTestWriter.class);
    private final TestGenKieSessionJournal journal;
    private final StringBuilder sb;
    private final Class<?> scoreDefClass;
    private final boolean constraintMatchEnabled;
    private final String score;

    public TestGenTestWriter(TestGenKieSessionJournal journal, Class<?> scoreDefClass, boolean constraintMatchEnabled, String score) {
        this.journal = journal;
        this.sb = new StringBuilder(32768);
        this.scoreDefClass = scoreDefClass;
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.score = score;
    }

    static void print(TestGenKieSessionJournal journal, File testFile) {
        new TestGenTestWriter(journal, null, false, null).print(testFile);
    }

    static void printWithScoreAssert(TestGenKieSessionJournal journal, Class<?> scoreDefClass, boolean constraintMatchEnabled, String score, File testFile) {
        new TestGenTestWriter(journal, scoreDefClass, constraintMatchEnabled, score).print(testFile);
    }

    private void print(File testFile) {
        this.printInit();
        this.printSetup();
        this.printTest();
        this.writeTestFile(testFile);
    }

    private void printInit() {
        String domainPackage = null;
        Iterator<TestGenFact> iterator = this.journal.getFacts().iterator();
        while (iterator.hasNext()) {
            Annotation ann;
            int n = 0;
            TestGenFact fact = iterator.next();
            Class<?> factClass = fact.getInstance().getClass();
            Annotation[] annotationArray = factClass.getAnnotations();
            int n2 = annotationArray.length;
            if (n < n2 && PlanningEntity.class.equals((ann = annotationArray[n]).annotationType())) {
                domainPackage = factClass.getPackage().getName();
            }
            if (domainPackage == null) continue;
            break;
        }
        if (domainPackage == null) {
            throw new IllegalStateException("Cannot determine planning domain package.");
        }
        this.sb.append(String.format("package %s;%n%n", domainPackage));
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("org.junit.Before");
        imports.add("org.junit.Test");
        imports.add("org.kie.api.KieServices");
        imports.add("org.kie.api.builder.KieFileSystem");
        imports.add("org.kie.api.builder.model.KieModuleModel");
        imports.add("org.kie.api.io.ResourceType");
        imports.add("org.kie.api.runtime.KieContainer");
        imports.add("org.kie.api.runtime.KieSession");
        if (this.scoreDefClass != null) {
            imports.add("org.junit.Assert");
            imports.add(Score.class.getCanonicalName());
            imports.add(ScoreHolder.class.getCanonicalName());
            imports.add(this.scoreDefClass.getCanonicalName());
        }
        for (TestGenFact fact : this.journal.getFacts()) {
            for (Class clazz : fact.getImports()) {
                String pkgName = clazz.getPackage().getName();
                if (pkgName.equals(domainPackage) || pkgName.equals("java.lang")) continue;
                imports.add(clazz.getCanonicalName());
            }
        }
        for (String cls : imports) {
            this.sb.append(String.format("import %s;%n", cls));
        }
        this.sb.append(System.lineSeparator()).append("public class DroolsReproducerTest {").append(System.lineSeparator()).append(System.lineSeparator()).append("    KieSession kieSession;").append(System.lineSeparator());
        for (TestGenFact fact : this.journal.getFacts()) {
            fact.printInitialization(this.sb);
        }
        this.sb.append(System.lineSeparator());
    }

    private void printSetup() {
        this.sb.append("    @Before").append(System.lineSeparator()).append("    public void setUp() {").append(System.lineSeparator()).append("        KieServices kieServices = KieServices.Factory.get();").append(System.lineSeparator()).append("        KieModuleModel kieModuleModel = kieServices.newKieModuleModel();").append(System.lineSeparator()).append("        KieFileSystem kfs = kieServices.newKieFileSystem();").append(System.lineSeparator()).append("        kfs.writeKModuleXML(kieModuleModel.toXML());").append(System.lineSeparator()).append("        kfs.write(kieServices.getResources()").append(System.lineSeparator()).append("                .newClassPathResource(\"org/optaplanner/examples/nurserostering/solver/nurseRosteringScoreRules.drl\")").append(System.lineSeparator()).append("                .setResourceType(ResourceType.DRL));").append(System.lineSeparator()).append("        kieServices.newKieBuilder(kfs).buildAll();").append(System.lineSeparator()).append("        KieContainer kieContainer = kieServices.newKieContainer(kieServices.getRepository().getDefaultReleaseId());").append(System.lineSeparator()).append("        kieSession = kieContainer.newKieSession();").append(System.lineSeparator()).append(System.lineSeparator());
        if (this.scoreDefClass != null) {
            this.sb.append("        kieSession.setGlobal(\"").append("scoreHolder").append("\", new ").append(this.scoreDefClass.getSimpleName()).append("().buildScoreHolder(").append(this.constraintMatchEnabled).append("));").append(System.lineSeparator()).append(System.lineSeparator());
        }
        for (TestGenFact testGenFact : this.journal.getFacts()) {
            testGenFact.printSetup(this.sb);
        }
        this.sb.append(System.lineSeparator());
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getInitialInserts()) {
            testGenKieSessionOperation.print(this.sb);
        }
        this.sb.append("    }").append(System.lineSeparator()).append(System.lineSeparator());
    }

    private void printTest() {
        this.sb.append("    @Test").append(System.lineSeparator()).append("    public void test() {").append(System.lineSeparator());
        for (TestGenKieSessionOperation op : this.journal.getMoveOperations()) {
            op.print(this.sb);
        }
        if (this.scoreDefClass != null) {
            this.sb.append("        Score<?> score = ((ScoreHolder) kieSession.getGlobal(\"").append("scoreHolder").append("\")).extractScore(0);").append(System.lineSeparator());
            this.sb.append("        Assert.assertEquals(\"").append(this.score).append("\", score.toString());").append(System.lineSeparator());
        }
        this.sb.append("    }").append(System.lineSeparator()).append("}").append(System.lineSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTestFile(File file) {
        OutputStreamWriter out;
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            logger.error("Cannot open test file: " + file.toString(), (Throwable)ex);
            return;
        }
        try {
            out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Can't open", (Throwable)ex);
            return;
        }
        try {
            out.append(this.sb);
        }
        catch (IOException ex) {
            logger.error("Can't write", (Throwable)ex);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                logger.error("Can't close", (Throwable)ex);
            }
        }
    }
}

