/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.fact;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenAbstractValueProvider;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;

class TestGenListValueProvider
extends TestGenAbstractValueProvider<List<?>> {
    private final String identifier;
    private final Type typeArgument;
    private final Map<Object, TestGenFact> existingInstances;
    private final List<Class<?>> imports = new ArrayList();

    public TestGenListValueProvider(List<?> value, String identifier, Type genericType, Map<Object, TestGenFact> existingInstances) {
        super(value);
        this.identifier = identifier;
        this.typeArgument = genericType;
        this.existingInstances = existingInstances;
        this.imports.add(ArrayList.class);
        this.imports.add((Class)genericType);
    }

    public List<TestGenFact> getFacts() {
        ArrayList<TestGenFact> facts = new ArrayList<TestGenFact>();
        for (Object o : (List)this.value) {
            TestGenFact fact = this.existingInstances.get(o);
            if (fact == null) continue;
            facts.add(fact);
        }
        return facts;
    }

    public List<Class<?>> getImports() {
        return this.imports;
    }

    @Override
    public void printSetup(StringBuilder sb) {
        String e = ((Class)this.typeArgument).getSimpleName();
        sb.append(String.format("        ArrayList<%s> %s = new ArrayList<%s>();%n", e, this.identifier, e));
        for (Object item : (List)this.value) {
            sb.append(String.format("        //%s%n", item));
            sb.append(String.format("        %s.add(%s);%n", this.identifier, this.existingInstances.get(item)));
        }
    }

    public String toString() {
        return this.identifier;
    }
}

