/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.SolutionDao;

public abstract class AbstractPngSolutionImporter<Solution_>
extends AbstractSolutionImporter<Solution_> {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = "png";

    protected AbstractPngSolutionImporter(SolutionDao<Solution_> solutionDao) {
        super(solutionDao);
    }

    protected AbstractPngSolutionImporter(boolean withoutDao) {
        super(withoutDao);
    }

    @Override
    public String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    public abstract PngInputBuilder<Solution_> createPngInputBuilder();

    @Override
    public Solution_ readSolution(File inputFile) {
        try {
            BufferedImage image = ImageIO.read(inputFile);
            PngInputBuilder<Solution_> pngInputBuilder = this.createPngInputBuilder();
            pngInputBuilder.setInputFile(inputFile);
            pngInputBuilder.setImage(image);
            try {
                Solution_ solution = pngInputBuilder.readSolution();
                this.logger.info("Imported: {}", (Object)inputFile);
                return solution;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Exception in inputFile (" + inputFile + ")", e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Exception in inputFile (" + inputFile + ")", e);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the file (" + inputFile.getName() + ").", e);
        }
    }

    public static abstract class PngInputBuilder<Solution_>
    extends AbstractSolutionImporter.InputBuilder {
        protected File inputFile;
        protected BufferedImage image;

        public void setInputFile(File inputFile) {
            this.inputFile = inputFile;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }

        public abstract Solution_ readSolution() throws IOException;

        public String getInputId() {
            return FilenameUtils.getBaseName((String)this.inputFile.getPath());
        }
    }
}

