/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoft;

import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardSoftScoreHolder
extends AbstractScoreHolder {
    protected int hardScore;
    protected int softScore;

    public HardSoftScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public int getHardScore() {
        return this.hardScore;
    }

    public int getSoftScore() {
        return this.softScore;
    }

    public void addHardConstraintMatch(RuleContext kcontext, final int weight) {
        this.hardScore += weight;
        this.registerIntConstraintMatch(kcontext, 0, weight, new AbstractScoreHolder.IntConstraintUndoListener(){

            @Override
            public void undo() {
                HardSoftScoreHolder.this.hardScore -= weight;
            }
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, final int weight) {
        this.softScore += weight;
        this.registerIntConstraintMatch(kcontext, 1, weight, new AbstractScoreHolder.IntConstraintUndoListener(){

            @Override
            public void undo() {
                HardSoftScoreHolder.this.softScore -= weight;
            }
        });
    }

    @Override
    public Score extractScore(int initScore) {
        return HardSoftScore.valueOf(initScore, this.hardScore, this.softScore);
    }
}

