/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.holder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.AgendaItem;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.Match;
import org.kie.api.runtime.rule.RuleContext;
import org.kie.api.runtime.rule.RuleRuntime;
import org.kie.internal.event.rule.ActivationUnMatchListener;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.bigdecimal.BigDecimalConstraintMatch;
import org.optaplanner.core.api.score.constraint.bigdecimal.BigDecimalConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.primdouble.DoubleConstraintMatch;
import org.optaplanner.core.api.score.constraint.primdouble.DoubleConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.primint.IntConstraintMatch;
import org.optaplanner.core.api.score.constraint.primint.IntConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.primlong.LongConstraintMatch;
import org.optaplanner.core.api.score.constraint.primlong.LongConstraintMatchTotal;
import org.optaplanner.core.api.score.holder.ScoreHolder;

public abstract class AbstractScoreHolder
implements ScoreHolder,
Serializable {
    protected final boolean constraintMatchEnabled;
    protected final Map<List<Object>, ConstraintMatchTotal> constraintMatchTotalMap;

    protected AbstractScoreHolder(boolean constraintMatchEnabled) {
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.constraintMatchTotalMap = constraintMatchEnabled ? new LinkedHashMap() : null;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabled;
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return this.constraintMatchTotalMap.values();
    }

    protected void registerIntConstraintMatch(RuleContext kcontext, int scoreLevel, int weight, IntConstraintUndoListener constraintUndoListener) {
        if (this.constraintMatchEnabled) {
            constraintUndoListener.constraintMatchTotal = this.findIntConstraintMatchTotal(kcontext, scoreLevel);
            constraintUndoListener.constraintMatch = constraintUndoListener.constraintMatchTotal.addConstraintMatch(kcontext, weight);
        }
        this.putConstraintUndoListener(kcontext, scoreLevel, constraintUndoListener);
    }

    private IntConstraintMatchTotal findIntConstraintMatchTotal(RuleContext kcontext, int scoreLevel) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        List<Object> key = Arrays.asList(constraintPackage, constraintName, scoreLevel);
        IntConstraintMatchTotal matchTotal = (IntConstraintMatchTotal)this.constraintMatchTotalMap.get(key);
        if (matchTotal == null) {
            matchTotal = new IntConstraintMatchTotal(constraintPackage, constraintName, scoreLevel);
            this.constraintMatchTotalMap.put(key, matchTotal);
        }
        return matchTotal;
    }

    protected void registerLongConstraintMatch(RuleContext kcontext, int scoreLevel, long weight, LongConstraintUndoListener constraintUndoListener) {
        if (this.constraintMatchEnabled) {
            constraintUndoListener.constraintMatchTotal = this.findLongConstraintMatchTotal(kcontext, scoreLevel);
            constraintUndoListener.constraintMatch = constraintUndoListener.constraintMatchTotal.addConstraintMatch(kcontext, weight);
        }
        this.putConstraintUndoListener(kcontext, scoreLevel, constraintUndoListener);
    }

    private LongConstraintMatchTotal findLongConstraintMatchTotal(RuleContext kcontext, int scoreLevel) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        List<Object> key = Arrays.asList(constraintPackage, constraintName, scoreLevel);
        LongConstraintMatchTotal matchTotal = (LongConstraintMatchTotal)this.constraintMatchTotalMap.get(key);
        if (matchTotal == null) {
            matchTotal = new LongConstraintMatchTotal(constraintPackage, constraintName, scoreLevel);
            this.constraintMatchTotalMap.put(key, matchTotal);
        }
        return matchTotal;
    }

    protected void registerDoubleConstraintMatch(RuleContext kcontext, int scoreLevel, double weight, DoubleConstraintUndoListener constraintUndoListener) {
        if (this.constraintMatchEnabled) {
            constraintUndoListener.constraintMatchTotal = this.findDoubleConstraintMatchTotal(kcontext, scoreLevel);
            constraintUndoListener.constraintMatch = constraintUndoListener.constraintMatchTotal.addConstraintMatch(kcontext, weight);
        }
        this.putConstraintUndoListener(kcontext, scoreLevel, constraintUndoListener);
    }

    private DoubleConstraintMatchTotal findDoubleConstraintMatchTotal(RuleContext kcontext, int scoreLevel) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        List<Object> key = Arrays.asList(constraintPackage, constraintName, scoreLevel);
        DoubleConstraintMatchTotal matchTotal = (DoubleConstraintMatchTotal)this.constraintMatchTotalMap.get(key);
        if (matchTotal == null) {
            matchTotal = new DoubleConstraintMatchTotal(constraintPackage, constraintName, scoreLevel);
            this.constraintMatchTotalMap.put(key, matchTotal);
        }
        return matchTotal;
    }

    protected void registerBigDecimalConstraintMatch(RuleContext kcontext, int scoreLevel, BigDecimal weight, BigDecimalConstraintUndoListener constraintUndoListener) {
        if (this.constraintMatchEnabled) {
            constraintUndoListener.constraintMatchTotal = this.findBigDecimalConstraintMatchTotal(kcontext, scoreLevel);
            constraintUndoListener.constraintMatch = constraintUndoListener.constraintMatchTotal.addConstraintMatch(kcontext, weight);
        }
        this.putConstraintUndoListener(kcontext, scoreLevel, constraintUndoListener);
    }

    private BigDecimalConstraintMatchTotal findBigDecimalConstraintMatchTotal(RuleContext kcontext, int scoreLevel) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        List<Object> key = Arrays.asList(constraintPackage, constraintName, scoreLevel);
        BigDecimalConstraintMatchTotal matchTotal = (BigDecimalConstraintMatchTotal)this.constraintMatchTotalMap.get(key);
        if (matchTotal == null) {
            matchTotal = new BigDecimalConstraintMatchTotal(constraintPackage, constraintName, scoreLevel);
            this.constraintMatchTotalMap.put(key, matchTotal);
        }
        return matchTotal;
    }

    private void putConstraintUndoListener(RuleContext kcontext, int scoreLevel, ConstraintUndoListener constraintUndoListener) {
        AgendaItem agendaItem = (AgendaItem)kcontext.getMatch();
        ActivationUnMatchListener activationUnMatchListener = agendaItem.getActivationUnMatchListener();
        if (activationUnMatchListener != null) {
            MultiLevelActivationUnMatchListener multiLevelActivationUnMatchListener = (MultiLevelActivationUnMatchListener)activationUnMatchListener;
            multiLevelActivationUnMatchListener.overwriteMatch(scoreLevel, constraintUndoListener);
        } else {
            MultiLevelActivationUnMatchListener multiLevelActivationUnMatchListener = new MultiLevelActivationUnMatchListener(scoreLevel, constraintUndoListener);
            agendaItem.setActivationUnMatchListener((ActivationUnMatchListener)multiLevelActivationUnMatchListener);
        }
    }

    private static class MultiLevelActivationUnMatchListener
    implements ActivationUnMatchListener {
        private static final int INITIAL_MAP_CAPACITY = 2;
        private Map<Integer, ConstraintUndoListener> scoreLevelToConstraintUndoListenerMap = new HashMap<Integer, ConstraintUndoListener>(2);

        public MultiLevelActivationUnMatchListener(int scoreLevel, ConstraintUndoListener constraintUndoListener) {
            this.scoreLevelToConstraintUndoListenerMap.put(scoreLevel, constraintUndoListener);
        }

        public final void unMatch(RuleRuntime ruleRuntime, Match match) {
            for (ConstraintUndoListener constraintUndoListener : this.scoreLevelToConstraintUndoListenerMap.values()) {
                constraintUndoListener.unMatch();
            }
            this.scoreLevelToConstraintUndoListenerMap.clear();
        }

        public void overwriteMatch(int scoreLevel, ConstraintUndoListener constraintUndoListener) {
            ConstraintUndoListener oldConstraintUndoListener = this.scoreLevelToConstraintUndoListenerMap.put(scoreLevel, constraintUndoListener);
            if (oldConstraintUndoListener != null) {
                oldConstraintUndoListener.unMatch();
            }
        }
    }

    protected static interface ConstraintUndoListener {
        public void unMatch();

        public void undo();
    }

    protected abstract class BigDecimalConstraintUndoListener
    implements ConstraintUndoListener {
        private BigDecimalConstraintMatchTotal constraintMatchTotal;
        private BigDecimalConstraintMatch constraintMatch;

        protected BigDecimalConstraintUndoListener() {
        }

        @Override
        public final void unMatch() {
            this.undo();
            if (AbstractScoreHolder.this.constraintMatchEnabled) {
                this.constraintMatchTotal.removeConstraintMatch(this.constraintMatch);
            }
        }
    }

    protected abstract class DoubleConstraintUndoListener
    implements ConstraintUndoListener {
        private DoubleConstraintMatchTotal constraintMatchTotal;
        private DoubleConstraintMatch constraintMatch;

        protected DoubleConstraintUndoListener() {
        }

        @Override
        public final void unMatch() {
            this.undo();
            if (AbstractScoreHolder.this.constraintMatchEnabled) {
                this.constraintMatchTotal.removeConstraintMatch(this.constraintMatch);
            }
        }
    }

    protected abstract class LongConstraintUndoListener
    implements ConstraintUndoListener {
        private LongConstraintMatchTotal constraintMatchTotal;
        private LongConstraintMatch constraintMatch;

        protected LongConstraintUndoListener() {
        }

        @Override
        public final void unMatch() {
            this.undo();
            if (AbstractScoreHolder.this.constraintMatchEnabled) {
                this.constraintMatchTotal.removeConstraintMatch(this.constraintMatch);
            }
        }
    }

    protected abstract class IntConstraintUndoListener
    implements ConstraintUndoListener {
        private IntConstraintMatchTotal constraintMatchTotal;
        private IntConstraintMatch constraintMatch;

        protected IntConstraintUndoListener() {
        }

        @Override
        public final void unMatch() {
            this.undo();
            if (AbstractScoreHolder.this.constraintMatchEnabled) {
                this.constraintMatchTotal.removeConstraintMatch(this.constraintMatch);
            }
        }
    }
}

