/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.locator;

import java.lang.reflect.Member;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.optaplanner.core.api.domain.locator.LocationStrategyType;
import org.optaplanner.core.api.domain.locator.PlanningId;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.locator.EqualsLocationStrategy;
import org.optaplanner.core.impl.domain.locator.ImmutableLocationStrategy;
import org.optaplanner.core.impl.domain.locator.LocationStrategy;
import org.optaplanner.core.impl.domain.locator.NoneLocationStrategy;
import org.optaplanner.core.impl.domain.locator.PlanningIdLocationStrategy;

public class LocationStrategyResolver {
    private final LocationStrategyType locationStrategyType;
    private final ConcurrentMap<Class<?>, LocationStrategy> decisionCache = new ConcurrentHashMap();

    public LocationStrategyResolver(LocationStrategyType locationStrategyType) {
        this.locationStrategyType = locationStrategyType;
        this.decisionCache.put(Boolean.class, new ImmutableLocationStrategy());
        this.decisionCache.put(Byte.class, new ImmutableLocationStrategy());
        this.decisionCache.put(Short.class, new ImmutableLocationStrategy());
        this.decisionCache.put(Integer.class, new ImmutableLocationStrategy());
        this.decisionCache.put(Long.class, new ImmutableLocationStrategy());
        this.decisionCache.put(Float.class, new ImmutableLocationStrategy());
        this.decisionCache.put(Double.class, new ImmutableLocationStrategy());
        this.decisionCache.put(BigInteger.class, new ImmutableLocationStrategy());
        this.decisionCache.put(BigDecimal.class, new ImmutableLocationStrategy());
        this.decisionCache.put(Character.class, new ImmutableLocationStrategy());
        this.decisionCache.put(String.class, new ImmutableLocationStrategy());
        this.decisionCache.put(LocalDate.class, new ImmutableLocationStrategy());
        this.decisionCache.put(LocalTime.class, new ImmutableLocationStrategy());
        this.decisionCache.put(LocalDateTime.class, new ImmutableLocationStrategy());
    }

    public LocationStrategy determineLocationStrategy(Object object) {
        Class<?> objectClass = object.getClass();
        return this.decisionCache.computeIfAbsent(objectClass, key -> {
            switch (this.locationStrategyType) {
                case PLANNING_ID_OR_NONE: {
                    MemberAccessor memberAccessor1 = this.findPlanningIdMemberAccessor(objectClass);
                    if (memberAccessor1 == null) {
                        return new NoneLocationStrategy();
                    }
                    return new PlanningIdLocationStrategy(memberAccessor1);
                }
                case PLANNING_ID_OR_FAIL_FAST: {
                    MemberAccessor memberAccessor2 = this.findPlanningIdMemberAccessor(objectClass);
                    if (memberAccessor2 == null) {
                        throw new IllegalArgumentException("The class (" + objectClass + ") does not have a " + PlanningId.class.getSimpleName() + " annotation, but the locationStrategyType (" + (Object)((Object)this.locationStrategyType) + ") requires it.\nMaybe add the " + PlanningId.class.getSimpleName() + " annotation or change the " + PlanningSolution.class.getSimpleName() + " annotation's " + LocationStrategyType.class.getSimpleName() + ".");
                    }
                    return new PlanningIdLocationStrategy(memberAccessor2);
                }
                case EQUALITY: {
                    return new EqualsLocationStrategy();
                }
                case NONE: {
                    return new NoneLocationStrategy();
                }
            }
            throw new IllegalStateException("The locationStrategyType (" + (Object)((Object)this.locationStrategyType) + ") is not implemented.");
        });
    }

    protected <C> MemberAccessor findPlanningIdMemberAccessor(Class<C> clazz) {
        List<Member> memberList = ConfigUtils.getAllMembers(clazz, PlanningId.class);
        if (memberList.isEmpty()) {
            return null;
        }
        if (memberList.size() > 1) {
            throw new IllegalStateException("The class (" + clazz + ") has " + memberList.size() + " members (" + memberList + ") with a " + PlanningId.class.getSimpleName() + " annotation.");
        }
        Member member = memberList.get(0);
        return ConfigUtils.buildMemberAccessor(member, ConfigUtils.MemberAccessorType.FIELD_OR_READ_METHOD, PlanningId.class);
    }
}

