/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.locator;

import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.core.api.domain.locator.LocationStrategyType;
import org.optaplanner.core.api.domain.locator.PlanningId;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.locator.LocationStrategy;

public class PlanningIdLocationStrategy
implements LocationStrategy {
    private MemberAccessor planningIdMemberAccessor;

    public PlanningIdLocationStrategy(MemberAccessor planningIdMemberAccessor) {
        this.planningIdMemberAccessor = planningIdMemberAccessor;
    }

    @Override
    public void addWorkingObject(Map<Object, Object> idToWorkingObjectMap, Object workingObject) {
        Object planningId = this.extractPlanningId(workingObject);
        Object oldAddedObject = idToWorkingObjectMap.put(planningId, workingObject);
        if (oldAddedObject != null) {
            throw new IllegalStateException("The workingObjects (" + oldAddedObject + ", " + workingObject + ") have the same planningId (" + planningId + ").");
        }
    }

    @Override
    public void removeWorkingObject(Map<Object, Object> idToWorkingObjectMap, Object workingObject) {
        Object planningId = this.extractPlanningId(workingObject);
        Object removedObject = idToWorkingObjectMap.remove(planningId);
        if (workingObject != removedObject) {
            throw new IllegalStateException("The workingObject (" + workingObject + ") differs from the removedObject (" + removedObject + ") for planningId (" + planningId + ").");
        }
    }

    @Override
    public <E> E locateWorkingObject(Map<Object, Object> idToWorkingObjectMap, E externalObject) {
        Object planningId = this.extractPlanningId(externalObject);
        return (E)idToWorkingObjectMap.get(planningId);
    }

    protected Object extractPlanningId(Object externalObject) {
        Object planningId = this.planningIdMemberAccessor.executeGetter(externalObject);
        if (planningId == null) {
            throw new IllegalArgumentException("The planningId (" + planningId + ") of the member (" + this.planningIdMemberAccessor + ") of the class (" + externalObject.getClass() + ") on externalObject (" + externalObject + ") must not be null.\nMaybe initialize the planningId of the original object before solving or remove the " + PlanningId.class.getSimpleName() + " annotation or change the " + PlanningSolution.class.getSimpleName() + " annotation's " + LocationStrategyType.class.getSimpleName() + ".");
        }
        return Pair.of(externalObject.getClass(), (Object)planningId);
    }
}

