/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionJournal;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionOperation;
import org.optaplanner.core.impl.score.director.drools.testgen.reproducer.TestGenCorruptedScoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestGenTestWriter {
    private static final Logger logger = LoggerFactory.getLogger(TestGenTestWriter.class);
    private StringBuilder sb;
    private TestGenKieSessionJournal journal;
    private List<String> scoreDrlList;
    private List<File> scoreDrlFileList;
    private ScoreDefinition<?> scoreDefinition;
    private boolean constraintMatchEnabled;
    private TestGenCorruptedScoreException scoreEx;

    TestGenTestWriter() {
    }

    public void print(TestGenKieSessionJournal journal, File testFile) {
        this.journal = journal;
        this.sb = new StringBuilder(32768);
        this.printInit();
        this.printSetup();
        this.printTest();
        this.writeTestFile(testFile);
    }

    private void printInit() {
        this.sb.append("package org.optaplanner.testgen;").append(System.lineSeparator()).append(System.lineSeparator());
        TreeSet<String> imports = new TreeSet<String>();
        imports.add("org.junit.Before");
        imports.add("org.junit.Test");
        imports.add("org.kie.api.KieServices");
        imports.add("org.kie.api.builder.KieFileSystem");
        imports.add("org.kie.api.runtime.KieContainer");
        imports.add("org.kie.api.runtime.KieSession");
        if (!this.scoreDrlFileList.isEmpty()) {
            imports.add("java.io.File");
        }
        if (this.scoreDefinition != null) {
            imports.add("org.junit.Assert");
            imports.add(ScoreHolder.class.getCanonicalName());
            imports.add(this.scoreDefinition.getClass().getCanonicalName());
        }
        for (TestGenFact fact : this.journal.getFacts()) {
            for (Class<?> cls : fact.getImports()) {
                String pkgName = cls.getPackage().getName();
                if (pkgName.equals("java.lang")) continue;
                imports.add(cls.getCanonicalName());
            }
        }
        for (String cls : imports) {
            this.sb.append(String.format("import %s;%n", cls));
        }
        this.sb.append(System.lineSeparator()).append("public class DroolsReproducerTest {").append(System.lineSeparator()).append(System.lineSeparator()).append("    KieContainer kieContainer;").append(System.lineSeparator()).append("    KieSession kieSession;").append(System.lineSeparator());
        if (this.scoreDefinition != null) {
            this.sb.append("    ScoreHolder scoreHolder = new ").append(this.scoreDefinition.getClass().getSimpleName()).append("().buildScoreHolder(").append(this.constraintMatchEnabled).append(");").append(System.lineSeparator());
        }
        for (TestGenFact fact : this.journal.getFacts()) {
            fact.printInitialization(this.sb);
        }
        this.sb.append(System.lineSeparator());
    }

    private void printSetup() {
        this.sb.append("    @Before").append(System.lineSeparator()).append("    public void setUp() {").append(System.lineSeparator()).append("        KieServices kieServices = KieServices.Factory.get();").append(System.lineSeparator()).append("        KieFileSystem kfs = kieServices.newKieFileSystem();").append(System.lineSeparator());
        this.scoreDrlFileList.forEach(file -> this.sb.append("        kfs.write(kieServices.getResources()").append(System.lineSeparator()).append("                .newFileSystemResource(new File(\"").append(file.getAbsoluteFile()).append("\"), \"UTF-8\"));").append(System.lineSeparator()));
        this.scoreDrlList.forEach(drl -> this.sb.append("        kfs.write(kieServices.getResources()").append(System.lineSeparator()).append("                .newClassPathResource(\"").append((String)drl).append("\"));").append(System.lineSeparator()));
        this.sb.append("        kieServices.newKieBuilder(kfs).buildAll();").append(System.lineSeparator()).append("        kieContainer = kieServices.newKieContainer(kieServices.getRepository().getDefaultReleaseId());").append(System.lineSeparator()).append("        kieSession = kieContainer.newKieSession();").append(System.lineSeparator()).append(System.lineSeparator());
        if (this.scoreDefinition != null) {
            this.sb.append("        kieSession.setGlobal(\"").append("scoreHolder").append("\", scoreHolder);").append(System.lineSeparator()).append(System.lineSeparator());
        }
        for (TestGenFact testGenFact : this.journal.getFacts()) {
            testGenFact.printSetup(this.sb);
        }
        this.sb.append(System.lineSeparator());
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getInitialInserts()) {
            testGenKieSessionOperation.print(this.sb);
        }
        this.sb.append("    }").append(System.lineSeparator()).append(System.lineSeparator());
    }

    private void printTest() {
        this.sb.append("    @Test").append(System.lineSeparator()).append("    public void test() {").append(System.lineSeparator());
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getMoveOperations()) {
            testGenKieSessionOperation.print(this.sb);
        }
        if (this.scoreEx != null) {
            this.sb.append("        // This is the corrupted score, just to make sure the bug is reproducible").append(System.lineSeparator()).append("        Assert.assertEquals(\"").append(this.scoreEx.getWorkingScore()).append("\", scoreHolder.extractScore(0).toString());").append(System.lineSeparator());
            this.sb.append("        kieSession = kieContainer.newKieSession();").append(System.lineSeparator()).append("        scoreHolder = new ").append(this.scoreDefinition.getClass().getSimpleName()).append("().buildScoreHolder(").append(this.constraintMatchEnabled).append(");").append(System.lineSeparator()).append("        kieSession.setGlobal(\"").append("scoreHolder").append("\", scoreHolder);").append(System.lineSeparator());
            this.sb.append(System.lineSeparator()).append(System.lineSeparator()).append("        // Insert everything into a fresh session to see the uncorrupted score").append(System.lineSeparator());
            for (TestGenKieSessionOperation testGenKieSessionOperation : this.journal.getInitialInserts()) {
                testGenKieSessionOperation.print(this.sb);
            }
            this.sb.append("        kieSession.fireAllRules();").append(System.lineSeparator()).append("        Assert.assertEquals(\"").append(this.scoreEx.getUncorruptedScore()).append("\", scoreHolder.extractScore(0).toString());").append(System.lineSeparator());
        }
        this.sb.append("    }").append(System.lineSeparator()).append("}").append(System.lineSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTestFile(File file) {
        OutputStreamWriter out;
        FileOutputStream fos;
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            logger.warn("Couldn't create directory: {}", (Object)parent);
        }
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            logger.error("Cannot open test file: " + file.toString(), (Throwable)ex);
            return;
        }
        try {
            out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error("Can't open", (Throwable)ex);
            return;
        }
        try {
            out.append(this.sb);
        }
        catch (IOException ex) {
            logger.error("Can't write", (Throwable)ex);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                logger.error("Can't close", (Throwable)ex);
            }
        }
    }

    public void setScoreDrlList(List<String> scoreDrlList) {
        this.scoreDrlList = scoreDrlList == null ? Collections.emptyList() : scoreDrlList;
    }

    public void setScoreDrlFileList(List<File> scoreDrlFileList) {
        this.scoreDrlFileList = scoreDrlFileList == null ? Collections.emptyList() : scoreDrlFileList;
    }

    public void setScoreDefinition(ScoreDefinition<?> scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public void setConstraintMatchEnabled(boolean constraintMatchEnabled) {
        this.constraintMatchEnabled = constraintMatchEnabled;
    }

    public void setCorruptedScoreException(TestGenCorruptedScoreException ex) {
        this.scoreEx = ex;
    }
}

