/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.ruleunit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.datasources.InternalDataSource;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.rule.EntryPointId;
import org.drools.core.util.ClassUtils;
import org.kie.api.runtime.rule.DataSource;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.RuleUnit;

public class RuleUnitDescr {
    private final Class<? extends RuleUnit> ruleUnitClass;
    private final Map<String, String> datasources = new HashMap<String, String>();
    private final Map<String, Class<?>> datasourceTypes = new HashMap();
    private final Map<String, Method> varAccessors = new HashMap<String, Method>();

    public RuleUnitDescr(Class<? extends RuleUnit> ruleUnitClass) {
        this.ruleUnitClass = ruleUnitClass;
        this.indexUnitVars();
    }

    public Class<? extends RuleUnit> getRuleUnitClass() {
        return this.ruleUnitClass;
    }

    public String getRuleUnitName() {
        return this.ruleUnitClass.getName();
    }

    private String getEntryPointName(String name) {
        return this.getRuleUnitName() + "." + name;
    }

    public Optional<EntryPointId> getEntryPointId(String name) {
        return Optional.ofNullable(this.datasources.get(name)).map(ds -> new EntryPointId(this.getEntryPointName(name)));
    }

    public Optional<Class<?>> getDatasourceType(String name) {
        return Optional.ofNullable(this.datasourceTypes.get(name));
    }

    public Optional<Class<?>> getVarType(String name) {
        return Optional.ofNullable(this.varAccessors.get(name)).map(m -> m.getReturnType());
    }

    public boolean hasVar(String name) {
        return this.varAccessors.get(name) != null;
    }

    public void bindDataSources(StatefulKnowledgeSessionImpl wm, RuleUnit ruleUnit) {
        this.datasources.forEach((name, accessor) -> this.bindDataSource(wm, ruleUnit, (String)name, (String)accessor));
    }

    public void unbindDataSources(StatefulKnowledgeSessionImpl wm, RuleUnit ruleUnit) {
        this.datasources.forEach((name, accessor) -> this.findDataSource(ruleUnit, (String)accessor).ifPresent(ds -> ds.unbind(ruleUnit)));
    }

    private void bindDataSource(StatefulKnowledgeSessionImpl wm, RuleUnit ruleUnit, String name, String accessor) {
        Optional<InternalDataSource> datasource = this.findDataSource(ruleUnit, accessor);
        Optional entrypoint = datasource.flatMap(ds -> this.propagateInserts(wm, ruleUnit, name, (InternalDataSource)ds));
    }

    public Object getValue(RuleUnit ruleUnit, String identifier) {
        Method m = this.varAccessors.get(identifier);
        if (m != null) {
            try {
                return m.invoke((Object)ruleUnit, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private Optional<InternalDataSource> findDataSource(RuleUnit ruleUnit, String accessor) {
        try {
            Object value = ruleUnit.getClass().getMethod(accessor, new Class[0]).invoke((Object)ruleUnit, new Object[0]);
            return value instanceof InternalDataSource ? Optional.of((InternalDataSource)value) : Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<WorkingMemoryEntryPoint> propagateInserts(StatefulKnowledgeSessionImpl wm, RuleUnit ruleUnit, String dataSourceName, InternalDataSource dataSource) {
        Optional<WorkingMemoryEntryPoint> entryPoint = Optional.ofNullable(wm.getEntryPoint(this.getEntryPointName(dataSourceName)));
        entryPoint.ifPresent(ep -> dataSource.bind(ruleUnit, (EntryPoint)ep));
        return entryPoint;
    }

    private void indexUnitVars() {
        for (Method m : this.ruleUnitClass.getMethods()) {
            String id;
            if (m.getDeclaringClass() == RuleUnit.class || m.getParameterCount() != 0 || (id = ClassUtils.getter2property(m.getName())) == null || id.equals("class")) continue;
            if (DataSource.class.isAssignableFrom(m.getReturnType())) {
                this.datasources.put(id, m.getName());
                Type returnType = m.getGenericReturnType();
                Class sourceType = returnType instanceof ParameterizedType ? (Class)((ParameterizedType)returnType).getActualTypeArguments()[0] : Object.class;
                this.datasourceTypes.put(id, sourceType);
            }
            this.varAccessors.put(id, m);
        }
    }
}

