/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellType;

public class SheetDataWriter {
    private static final POILogger logger = POILogFactory.getLogger(SheetDataWriter.class);
    private final File _fd = this.createTempFile();
    private final Writer _out = this.createWriter(this._fd);
    private int _rownum;
    private int _numberOfFlushedRows;
    private int _lowestIndexOfFlushedRows;
    private int _numberOfCellsOfLastFlushedRow;
    private int _numberLastFlushedRow = -1;
    private SharedStringsTable _sharedStringSource;

    public SheetDataWriter() throws IOException {
    }

    public SheetDataWriter(SharedStringsTable sharedStringsTable) throws IOException {
        this();
        this._sharedStringSource = sharedStringsTable;
    }

    public File createTempFile() throws IOException {
        return TempFile.createTempFile((String)"poi-sxssf-sheet", (String)".xml");
    }

    public Writer createWriter(File fd) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fd), "UTF-8"));
    }

    public void close() throws IOException {
        this._out.flush();
        this._out.close();
    }

    File getTempFile() {
        return this._fd;
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        File fd = this.getTempFile();
        return new FileInputStream(fd);
    }

    public int getNumberOfFlushedRows() {
        return this._numberOfFlushedRows;
    }

    public int getNumberOfCellsOfLastFlushedRow() {
        return this._numberOfCellsOfLastFlushedRow;
    }

    public int getLowestIndexOfFlushedRows() {
        return this._lowestIndexOfFlushedRows;
    }

    public int getLastFlushedRow() {
        return this._numberLastFlushedRow;
    }

    protected void finalize() throws Throwable {
        if (!this._fd.delete()) {
            logger.log(7, new Object[]{"Can't delete temporary encryption file: " + this._fd});
        }
        super.finalize();
    }

    public void writeRow(int rownum, SXSSFRow row) throws IOException {
        if (this._numberOfFlushedRows == 0) {
            this._lowestIndexOfFlushedRows = rownum;
        }
        this._numberLastFlushedRow = Math.max(rownum, this._numberLastFlushedRow);
        this._numberOfCellsOfLastFlushedRow = row.getLastCellNum();
        ++this._numberOfFlushedRows;
        this.beginRow(rownum, row);
        Iterator<Cell> cells = row.allCellsIterator();
        int columnIndex = 0;
        while (cells.hasNext()) {
            this.writeCell(columnIndex++, cells.next());
        }
        this.endRow();
    }

    void beginRow(int rownum, SXSSFRow row) throws IOException {
        this._out.write("<row r=\"" + (rownum + 1) + "\"");
        if (row.hasCustomHeight()) {
            this._out.write(" customHeight=\"true\"  ht=\"" + row.getHeightInPoints() + "\"");
        }
        if (row.getZeroHeight()) {
            this._out.write(" hidden=\"true\"");
        }
        if (row.isFormatted()) {
            this._out.write(" s=\"" + row.getRowStyleIndex() + "\"");
            this._out.write(" customFormat=\"1\"");
        }
        if (row.getOutlineLevel() != 0) {
            this._out.write(" outlineLevel=\"" + row.getOutlineLevel() + "\"");
        }
        if (row.getHidden() != null) {
            this._out.write(" hidden=\"" + (row.getHidden() != false ? "1" : "0") + "\"");
        }
        if (row.getCollapsed() != null) {
            this._out.write(" collapsed=\"" + (row.getCollapsed() != false ? "1" : "0") + "\"");
        }
        this._out.write(">\n");
        this._rownum = rownum;
    }

    void endRow() throws IOException {
        this._out.write("</row>\n");
    }

    public void writeCell(int columnIndex, Cell cell) throws IOException {
        if (cell == null) {
            return;
        }
        String ref = new CellReference(this._rownum, columnIndex).formatAsString();
        this._out.write("<c r=\"" + ref + "\"");
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle.getIndex() != 0) {
            this._out.write(" s=\"" + (cellStyle.getIndex() & 0xFFFF) + "\"");
        }
        CellType cellType = cell.getCellTypeEnum();
        block0 : switch (cellType) {
            case BLANK: {
                this._out.write(">");
                break;
            }
            case FORMULA: {
                this._out.write(">");
                this._out.write("<f>");
                this.outputQuotedString(cell.getCellFormula());
                this._out.write("</f>");
                switch (cell.getCachedFormulaResultTypeEnum()) {
                    case NUMERIC: {
                        double nval = cell.getNumericCellValue();
                        if (Double.isNaN(nval)) break block0;
                        this._out.write("<v>" + nval + "</v>");
                        break;
                    }
                }
                break;
            }
            case STRING: {
                if (this._sharedStringSource != null) {
                    XSSFRichTextString rt = new XSSFRichTextString(cell.getStringCellValue());
                    int sRef = this._sharedStringSource.addEntry(rt.getCTRst());
                    this._out.write(" t=\"" + STCellType.S.toString() + "\">");
                    this._out.write("<v>");
                    this._out.write(String.valueOf(sRef));
                    this._out.write("</v>");
                    break;
                }
                this._out.write(" t=\"inlineStr\">");
                this._out.write("<is><t");
                if (this.hasLeadingTrailingSpaces(cell.getStringCellValue())) {
                    this._out.write(" xml:space=\"preserve\"");
                }
                this._out.write(">");
                this.outputQuotedString(cell.getStringCellValue());
                this._out.write("</t></is>");
                break;
            }
            case NUMERIC: {
                this._out.write(" t=\"n\">");
                this._out.write("<v>" + cell.getNumericCellValue() + "</v>");
                break;
            }
            case BOOLEAN: {
                this._out.write(" t=\"b\">");
                this._out.write("<v>" + (cell.getBooleanCellValue() ? "1" : "0") + "</v>");
                break;
            }
            case ERROR: {
                FormulaError error = FormulaError.forInt((byte)cell.getErrorCellValue());
                this._out.write(" t=\"e\">");
                this._out.write("<v>" + error.getString() + "</v>");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid cell type: " + cellType);
            }
        }
        this._out.write("</c>");
    }

    boolean hasLeadingTrailingSpaces(String str) {
        if (str != null && str.length() > 0) {
            char firstChar = str.charAt(0);
            char lastChar = str.charAt(str.length() - 1);
            return Character.isWhitespace(firstChar) || Character.isWhitespace(lastChar);
        }
        return false;
    }

    protected void outputQuotedString(String s) throws IOException {
        if (s == null || s.length() == 0) {
            return;
        }
        char[] chars = s.toCharArray();
        int last = 0;
        int length = s.length();
        block9: for (int counter = 0; counter < length; ++counter) {
            char c = chars[counter];
            switch (c) {
                case '<': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&lt;");
                    continue block9;
                }
                case '>': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&gt;");
                    continue block9;
                }
                case '&': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&amp;");
                    continue block9;
                }
                case '\"': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&quot;");
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    this._out.write("&#xa;");
                    last = counter + 1;
                    continue block9;
                }
                case '\t': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    this._out.write("&#x9;");
                    last = counter + 1;
                    continue block9;
                }
                case '\u00a0': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    this._out.write("&#xa0;");
                    last = counter + 1;
                    continue block9;
                }
                default: {
                    if (c < ' ' || Character.isLowSurrogate(c) || Character.isHighSurrogate(c) || '\ufffe' <= c && c <= '\uffff') {
                        if (counter > last) {
                            this._out.write(chars, last, counter - last);
                        }
                        this._out.write(63);
                        last = counter + 1;
                        continue block9;
                    }
                    if (c <= '\u007f') continue block9;
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&#");
                    this._out.write(String.valueOf((int)c));
                    this._out.write(";");
                }
            }
        }
        if (last < length) {
            this._out.write(chars, last, length - last);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dispose() throws IOException {
        boolean ret;
        try {
            this._out.close();
        }
        finally {
            ret = this._fd.delete();
        }
        return ret;
    }
}

