/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.coachshuttlegathering.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.examples.coachshuttlegathering.domain.Bus;
import org.optaplanner.examples.coachshuttlegathering.domain.BusHub;
import org.optaplanner.examples.coachshuttlegathering.domain.StopOrHub;
import org.optaplanner.examples.coachshuttlegathering.domain.location.RoadLocation;

@XStreamAlias(value="CsgCoach")
public class Coach
extends Bus {
    protected int stopLimit;
    protected BusHub destination;

    public int getStopLimit() {
        return this.stopLimit;
    }

    public void setStopLimit(int stopLimit) {
        this.stopLimit = stopLimit;
    }

    public void setDestination(BusHub destination) {
        this.destination = destination;
    }

    @Override
    public int getSetupCost() {
        return 0;
    }

    @Override
    public int getDistanceFromTo(RoadLocation sourceLocation, RoadLocation targetLocation) {
        return sourceLocation.getCoachDistanceTo(targetLocation);
    }

    @Override
    public int getDurationFromTo(RoadLocation sourceLocation, RoadLocation targetLocation) {
        return sourceLocation.getCoachDurationTo(targetLocation);
    }

    @Override
    public StopOrHub getDestination() {
        return this.destination;
    }

    public int getDistanceToDestinationCost() {
        return this.getDistanceFromTo(this.departureLocation, this.destination.getLocation()) * this.getMileageCost();
    }
}

