/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain.solver;

import org.apache.commons.lang3.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TspSolution;

public class DomicileDistanceStandstillStrengthWeightFactory
implements SelectionSorterWeightFactory<TspSolution, Standstill> {
    public Comparable createSorterWeight(TspSolution tspSolution, Standstill standstill) {
        Domicile domicile = tspSolution.getDomicile();
        long domicileRoundTripDistance = domicile.getDistanceTo(standstill) + standstill.getDistanceTo(domicile);
        return new DomicileDistanceStandstillStrengthWeight(standstill, domicileRoundTripDistance);
    }

    public static class DomicileDistanceStandstillStrengthWeight
    implements Comparable<DomicileDistanceStandstillStrengthWeight> {
        private final Standstill standstill;
        private final long domicileRoundTripDistance;

        public DomicileDistanceStandstillStrengthWeight(Standstill standstill, long domicileRoundTripDistance) {
            this.standstill = standstill;
            this.domicileRoundTripDistance = domicileRoundTripDistance;
        }

        @Override
        public int compareTo(DomicileDistanceStandstillStrengthWeight other) {
            return new CompareToBuilder().append(other.domicileRoundTripDistance, this.domicileRoundTripDistance).append(this.standstill.getLocation().getLatitude(), other.standstill.getLocation().getLatitude()).append(this.standstill.getLocation().getLongitude(), other.standstill.getLocation().getLongitude()).toComparison();
        }
    }
}

