/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.descriptor;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.valuerange.buildin.collection.ListValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.AbstractValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public abstract class AbstractFromPropertyValueRangeDescriptor<Solution_>
extends AbstractValueRangeDescriptor<Solution_> {
    protected final MemberAccessor memberAccessor;
    protected boolean collectionWrapping;
    protected boolean arrayWrapping;
    protected boolean countable;

    public AbstractFromPropertyValueRangeDescriptor(GenuineVariableDescriptor<Solution_> variableDescriptor, boolean addNullInValueRange, MemberAccessor memberAccessor) {
        super(variableDescriptor, addNullInValueRange);
        this.memberAccessor = memberAccessor;
        ValueRangeProvider valueRangeProviderAnnotation = memberAccessor.getAnnotation(ValueRangeProvider.class);
        if (valueRangeProviderAnnotation == null) {
            throw new IllegalStateException("The member (" + memberAccessor + ") must have a valueRangeProviderAnnotation (" + valueRangeProviderAnnotation + ").");
        }
        this.processValueRangeProviderAnnotation(valueRangeProviderAnnotation);
        if (addNullInValueRange && !this.countable) {
            throw new IllegalStateException("The valueRangeDescriptor (" + this + ") is nullable, but not countable (" + this.countable + ").\nMaybe the member (" + memberAccessor + ") should return " + CountableValueRange.class.getSimpleName() + ".");
        }
    }

    private void processValueRangeProviderAnnotation(ValueRangeProvider valueRangeProviderAnnotation) {
        EntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        Class<?> type = this.memberAccessor.getType();
        this.collectionWrapping = Collection.class.isAssignableFrom(type);
        this.arrayWrapping = type.isArray();
        if (!(this.collectionWrapping || this.arrayWrapping || ValueRange.class.isAssignableFrom(type))) {
            throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a " + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that does not return a " + Collection.class.getSimpleName() + ", an array or a " + ValueRange.class.getSimpleName() + ".");
        }
        if (this.collectionWrapping) {
            Type genericType = this.memberAccessor.getGenericType();
            if (!(genericType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a " + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that returns a " + Collection.class.getSimpleName() + " which has no generic parameters.\nMaybe the member (" + this.memberAccessor + ") should return a typed " + Collection.class.getSimpleName() + ".");
            }
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a " + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that returns a parameterized " + Collection.class.getSimpleName() + ") with an unsupported number of generic parameters (" + typeArguments.length + ").");
            }
            Type typeArgument = typeArguments[0];
            if (typeArgument instanceof ParameterizedType) {
                typeArgument = ((ParameterizedType)typeArgument).getRawType();
            }
            if (!(typeArgument instanceof Class)) {
                throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a " + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that returns a parameterized " + Collection.class.getSimpleName() + " with an unsupported type arguments (" + typeArgument + ").");
            }
            Class collectionElementClass = (Class)typeArgument;
            Class<?> variablePropertyType = this.variableDescriptor.getVariablePropertyType();
            if (!variablePropertyType.isAssignableFrom(collectionElementClass)) {
                throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a " + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that returns a " + Collection.class.getSimpleName() + " with elements of type (" + collectionElementClass + ") which cannot be assigned to the " + PlanningVariable.class.getSimpleName() + "'s type (" + variablePropertyType + ").");
            }
        } else if (this.arrayWrapping) {
            Class<?> arrayElementClass = type.getComponentType();
            Class<?> variablePropertyType = this.variableDescriptor.getVariablePropertyType();
            if (!variablePropertyType.isAssignableFrom(arrayElementClass)) {
                throw new IllegalArgumentException("The entityClass (" + entityDescriptor.getEntityClass() + ") has a " + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableDescriptor.getVariableName() + ") that refers to a " + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") that returns a array with elements of type (" + arrayElementClass + ") which cannot be assigned to the " + PlanningVariable.class.getSimpleName() + "'s type (" + variablePropertyType + ").");
            }
        }
        this.countable = this.collectionWrapping || this.arrayWrapping || CountableValueRange.class.isAssignableFrom(type);
    }

    @Override
    public boolean isCountable() {
        return this.countable;
    }

    protected ValueRange<?> readValueRange(Object bean) {
        ValueRange<Object> valueRange;
        Object valueRangeObject = this.memberAccessor.executeGetter(bean);
        if (valueRangeObject == null) {
            throw new IllegalStateException("The @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") called on bean (" + bean + ") must not return a null valueRangeObject (" + valueRangeObject + ").");
        }
        if (this.collectionWrapping) {
            List list = this.transformCollectionToList((Collection)valueRangeObject);
            valueRange = new ListValueRange(list);
        } else if (this.arrayWrapping) {
            List<Object> list = this.transformArrayToList(valueRangeObject);
            valueRange = new ListValueRange<Object>(list);
        } else {
            valueRange = (ListValueRange)valueRangeObject;
        }
        valueRange = this.doNullInValueRangeWrapping(valueRange);
        if (valueRange.isEmpty()) {
            throw new IllegalStateException("The @" + ValueRangeProvider.class.getSimpleName() + " annotated member (" + this.memberAccessor + ") called on bean (" + bean + ") must not return an empty valueRange (" + valueRangeObject + ").\n  If this a valid dataset, apply overconstrained planning as described in the documentation.");
        }
        return valueRange;
    }

    private <T> List<T> transformCollectionToList(Collection<T> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    private List<Object> transformArrayToList(Object valueRangeObject) {
        int arrayLength = Array.getLength(valueRangeObject);
        ArrayList<Object> list = new ArrayList<Object>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            list.add(Array.get(valueRangeObject, i));
        }
        return list;
    }
}

