/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.xstream.impl.domain.solution;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class XStreamSolutionFileIO<Solution_>
implements SolutionFileIO<Solution_> {
    public static final String FILE_EXTENSION = "xml";
    protected XStream xStream = new XStream();

    public XStreamSolutionFileIO(Class ... xStreamAnnotatedClasses) {
        this.xStream.setMode(1002);
        this.xStream.processAnnotations(xStreamAnnotatedClasses);
    }

    public XStream getXStream() {
        return this.xStream;
    }

    public String getInputFileExtension() {
        return FILE_EXTENSION;
    }

    public String getOutputFileExtension() {
        return FILE_EXTENSION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Solution_ read(File inputSolutionFile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(inputSolutionFile), "UTF-8");){
            Object object = this.xStream.fromXML((Reader)reader);
            return (Solution_)object;
        }
        catch (XStreamException | IOException e) {
            throw new IllegalArgumentException("Failed reading inputSolutionFile (" + inputSolutionFile + ").", e);
        }
    }

    public void write(Solution_ solution, File outputSolutionFile) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputSolutionFile), "UTF-8");){
            this.xStream.toXML(solution, (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed writing outputSolutionFile (" + outputSolutionFile + ").", e);
        }
    }
}

