/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.swingui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.conferencescheduling.domain.ConferenceSolution;
import org.optaplanner.examples.conferencescheduling.persistence.ConferenceSchedulingXlsxFileIO;

public class ConferenceSchedulingPanel
extends SolutionPanel<ConferenceSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/conferencescheduling/swingui/conferenceSchedulingLogo.png";

    public ConferenceSchedulingPanel() {
        JButton button = new JButton("Show in LibreOffice or Excel");
        button.addActionListener(event -> {
            File tempFile;
            ConferenceSchedulingXlsxFileIO solutionFileIO = new ConferenceSchedulingXlsxFileIO();
            try {
                tempFile = File.createTempFile(this.solutionBusiness.getSolutionFileName(), "." + solutionFileIO.getOutputFileExtension());
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create temp file.", e);
            }
            solutionFileIO.write(this.solutionBusiness.getSolution(), tempFile);
            try {
                Desktop.getDesktop().open(tempFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to show temp file (" + tempFile + ") in LibreOffice or Excel.", e);
            }
        });
        this.add(button);
        this.add(new JLabel("Changes to that file are ignored unless you explicitly save it there and open it here."));
    }

    @Override
    public void resetPanel(ConferenceSolution solution) {
    }
}

