/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.move.generic;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.SwapMoveSelector;

@XStreamAlias(value="swapMoveSelector")
public class SwapMoveSelectorConfig
extends MoveSelectorConfig<SwapMoveSelectorConfig> {
    @XStreamAlias(value="entitySelector")
    private EntitySelectorConfig entitySelectorConfig = null;
    @XStreamAlias(value="secondaryEntitySelector")
    private EntitySelectorConfig secondaryEntitySelectorConfig = null;
    @XStreamImplicit(itemFieldName="variableNameInclude")
    private List<String> variableNameIncludeList = null;

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public EntitySelectorConfig getSecondaryEntitySelectorConfig() {
        return this.secondaryEntitySelectorConfig;
    }

    public void setSecondaryEntitySelectorConfig(EntitySelectorConfig secondaryEntitySelectorConfig) {
        this.secondaryEntitySelectorConfig = secondaryEntitySelectorConfig;
    }

    public List<String> getVariableNameIncludeList() {
        return this.variableNameIncludeList;
    }

    public void setVariableNameIncludeList(List<String> variableNameIncludeList) {
        this.variableNameIncludeList = variableNameIncludeList;
    }

    @Override
    public MoveSelector buildBaseMoveSelector(HeuristicConfigPolicy configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        EntitySelectorConfig entitySelectorConfig_ = this.entitySelectorConfig == null ? new EntitySelectorConfig() : this.entitySelectorConfig;
        EntitySelector leftEntitySelector = entitySelectorConfig_.buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        EntitySelectorConfig rightEntitySelectorConfig = (EntitySelectorConfig)ObjectUtils.defaultIfNull((Object)this.secondaryEntitySelectorConfig, (Object)entitySelectorConfig_);
        EntitySelector rightEntitySelector = rightEntitySelectorConfig.buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection));
        List<GenuineVariableDescriptor> variableDescriptorList = this.deduceVariableDescriptorList(leftEntitySelector.getEntityDescriptor(), this.variableNameIncludeList);
        return new SwapMoveSelector(leftEntitySelector, rightEntitySelector, variableDescriptorList, randomSelection);
    }

    @Override
    protected MoveSelectorConfig buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy configPolicy) {
        EntityDescriptor onlySecondaryEntityDescriptor;
        EntityDescriptor onlyEntityDescriptor;
        EntityDescriptor entityDescriptor = onlyEntityDescriptor = this.entitySelectorConfig == null ? null : this.entitySelectorConfig.extractEntityDescriptor(configPolicy);
        if (this.secondaryEntitySelectorConfig != null && onlyEntityDescriptor != (onlySecondaryEntityDescriptor = this.secondaryEntitySelectorConfig.extractEntityDescriptor(configPolicy))) {
            throw new IllegalArgumentException("The entitySelector (" + this.entitySelectorConfig + ")'s entityClass (" + (onlyEntityDescriptor == null ? null : onlyEntityDescriptor.getEntityClass()) + ") and secondaryEntitySelectorConfig (" + this.secondaryEntitySelectorConfig + ")'s entityClass (" + (onlySecondaryEntityDescriptor == null ? null : onlySecondaryEntityDescriptor.getEntityClass()) + ") must be the same entity class.");
        }
        if (onlyEntityDescriptor != null) {
            return null;
        }
        Collection<EntityDescriptor> entityDescriptors = configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
        return this.buildUnfoldedMoveSelectorConfig(entityDescriptors);
    }

    protected MoveSelectorConfig buildUnfoldedMoveSelectorConfig(Collection<EntityDescriptor> entityDescriptors) {
        ArrayList<MoveSelectorConfig> moveSelectorConfigList = new ArrayList<MoveSelectorConfig>(entityDescriptors.size());
        for (EntityDescriptor entityDescriptor : entityDescriptors) {
            SwapMoveSelectorConfig childMoveSelectorConfig = new SwapMoveSelectorConfig();
            EntitySelectorConfig childEntitySelectorConfig = new EntitySelectorConfig(this.entitySelectorConfig);
            if (childEntitySelectorConfig.getMimicSelectorRef() == null) {
                childEntitySelectorConfig.setEntityClass(entityDescriptor.getEntityClass());
            }
            childMoveSelectorConfig.setEntitySelectorConfig(childEntitySelectorConfig);
            if (this.secondaryEntitySelectorConfig != null) {
                EntitySelectorConfig childSecondaryEntitySelectorConfig = new EntitySelectorConfig(this.secondaryEntitySelectorConfig);
                if (childSecondaryEntitySelectorConfig.getMimicSelectorRef() == null) {
                    childSecondaryEntitySelectorConfig.setEntityClass(entityDescriptor.getEntityClass());
                }
                childMoveSelectorConfig.setSecondaryEntitySelectorConfig(childSecondaryEntitySelectorConfig);
            }
            childMoveSelectorConfig.setVariableNameIncludeList(this.variableNameIncludeList);
            moveSelectorConfigList.add(childMoveSelectorConfig);
        }
        MoveSelectorConfig unfoldedMoveSelectorConfig = moveSelectorConfigList.size() == 1 ? (MoveSelectorConfig)moveSelectorConfigList.get(0) : new UnionMoveSelectorConfig(moveSelectorConfigList);
        unfoldedMoveSelectorConfig.inheritFolded(this);
        return unfoldedMoveSelectorConfig;
    }

    @Override
    public void inherit(SwapMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.secondaryEntitySelectorConfig = ConfigUtils.inheritConfig(this.secondaryEntitySelectorConfig, inheritedConfig.getSecondaryEntitySelectorConfig());
        this.variableNameIncludeList = ConfigUtils.inheritMergeableListProperty(this.variableNameIncludeList, inheritedConfig.getVariableNameIncludeList());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + (this.secondaryEntitySelectorConfig == null ? "" : ", " + this.secondaryEntitySelectorConfig) + ")";
    }
}

