/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simplebigdecimal;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class SimpleBigDecimalScoreHolder
extends AbstractScoreHolder<SimpleBigDecimalScore> {
    protected final Map<Rule, BiConsumer<RuleContext, BigDecimal>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, BigDecimal>>();
    protected BigDecimal score = BigDecimal.ZERO;

    public SimpleBigDecimalScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, SimpleBigDecimalScore.ZERO);
    }

    public BigDecimal getScore() {
        return this.score;
    }

    @Override
    public void configureConstraintWeight(Rule rule, SimpleBigDecimalScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        BiConsumer<RuleContext, BigDecimal> matchExecutor = constraintWeight.equals(SimpleBigDecimalScore.ZERO) ? (kcontext, matchWeight) -> {} : (kcontext, matchWeight) -> this.addConstraintMatch((RuleContext)kcontext, constraintWeight.getScore().multiply((BigDecimal)matchWeight));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
    }

    public void penalize(RuleContext kcontext) {
        this.reward(kcontext, BigDecimal.ONE.negate());
    }

    public void penalize(RuleContext kcontext, BigDecimal weightMultiplier) {
        this.reward(kcontext, weightMultiplier.negate());
    }

    public void reward(RuleContext kcontext) {
        this.reward(kcontext, BigDecimal.ONE);
    }

    public void reward(RuleContext kcontext, BigDecimal weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, BigDecimal> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    public void addConstraintMatch(RuleContext kcontext, BigDecimal weight) {
        this.score = this.score.add(weight);
        this.registerConstraintMatch(kcontext, () -> {
            this.score = this.score.subtract(weight);
        }, () -> SimpleBigDecimalScore.of(weight));
    }

    @Override
    public SimpleBigDecimalScore extractScore(int initScore) {
        return SimpleBigDecimalScore.ofUninitialized(initScore, this.score);
    }
}

