/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.simplelong;

import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.Score;

public final class SimpleLongScore
extends AbstractScore<SimpleLongScore> {
    public static final SimpleLongScore ZERO = new SimpleLongScore(0, 0L);
    private final long score;

    public static SimpleLongScore parseScore(String scoreString) {
        String[] scoreTokens = SimpleLongScore.parseScoreTokens(SimpleLongScore.class, scoreString, "");
        int initScore = SimpleLongScore.parseInitScore(SimpleLongScore.class, scoreString, scoreTokens[0]);
        long score = SimpleLongScore.parseLevelAsLong(SimpleLongScore.class, scoreString, scoreTokens[1]);
        return SimpleLongScore.ofUninitialized(initScore, score);
    }

    public static SimpleLongScore ofUninitialized(int initScore, long score) {
        return new SimpleLongScore(initScore, score);
    }

    @Deprecated
    public static SimpleLongScore valueOfUninitialized(int initScore, long score) {
        return new SimpleLongScore(initScore, score);
    }

    public static SimpleLongScore of(long score) {
        return new SimpleLongScore(0, score);
    }

    @Deprecated
    public static SimpleLongScore valueOf(long score) {
        return new SimpleLongScore(0, score);
    }

    private SimpleLongScore() {
        super(Integer.MIN_VALUE);
        this.score = Long.MIN_VALUE;
    }

    private SimpleLongScore(int initScore, long score) {
        super(initScore);
        this.score = score;
    }

    public long getScore() {
        return this.score;
    }

    @Override
    public SimpleLongScore toInitializedScore() {
        return this.initScore == 0 ? this : new SimpleLongScore(0, this.score);
    }

    @Override
    public SimpleLongScore withInitScore(int newInitScore) {
        this.assertNoInitScore();
        return new SimpleLongScore(newInitScore, this.score);
    }

    @Override
    public SimpleLongScore add(SimpleLongScore addend) {
        return new SimpleLongScore(this.initScore + addend.getInitScore(), this.score + addend.getScore());
    }

    @Override
    public SimpleLongScore subtract(SimpleLongScore subtrahend) {
        return new SimpleLongScore(this.initScore - subtrahend.getInitScore(), this.score - subtrahend.getScore());
    }

    @Override
    public SimpleLongScore multiply(double multiplicand) {
        return new SimpleLongScore((int)Math.floor((double)this.initScore * multiplicand), (long)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public SimpleLongScore divide(double divisor) {
        return new SimpleLongScore((int)Math.floor((double)this.initScore / divisor), (long)Math.floor((double)this.score / divisor));
    }

    @Override
    public SimpleLongScore power(double exponent) {
        return new SimpleLongScore((int)Math.floor(Math.pow(this.initScore, exponent)), (long)Math.floor(Math.pow(this.score, exponent)));
    }

    @Override
    public SimpleLongScore negate() {
        return new SimpleLongScore(-this.initScore, -this.score);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleLongScore) {
            SimpleLongScore other = (SimpleLongScore)o;
            return this.initScore == other.getInitScore() && this.score == other.getScore();
        }
        return false;
    }

    public int hashCode() {
        return (629 + this.initScore) * 37 + Long.valueOf(this.score).hashCode();
    }

    @Override
    public int compareTo(SimpleLongScore other) {
        if (this.initScore != other.getInitScore()) {
            return this.initScore < other.getInitScore() ? -1 : 1;
        }
        return Long.compare(this.score, other.getScore());
    }

    @Override
    public String toShortString() {
        return this.buildShortString(n -> (Long)n != 0L, "");
    }

    public String toString() {
        return this.getInitPrefix() + this.score;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        return otherScore instanceof SimpleLongScore;
    }
}

