/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.localsearch;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import org.optaplanner.core.config.localsearch.LocalSearchType;
import org.optaplanner.core.config.localsearch.decider.acceptor.AcceptorConfig;
import org.optaplanner.core.config.localsearch.decider.acceptor.AcceptorType;
import org.optaplanner.core.config.localsearch.decider.forager.LocalSearchForagerConfig;
import org.optaplanner.core.config.localsearch.decider.forager.LocalSearchPickEarlyType;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.localsearch.DefaultLocalSearchPhase;
import org.optaplanner.core.impl.localsearch.LocalSearchPhase;
import org.optaplanner.core.impl.localsearch.decider.LocalSearchDecider;
import org.optaplanner.core.impl.localsearch.decider.MultiThreadedLocalSearchDecider;
import org.optaplanner.core.impl.localsearch.decider.acceptor.Acceptor;
import org.optaplanner.core.impl.localsearch.decider.forager.LocalSearchForager;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamAlias(value="localSearch")
public class LocalSearchPhaseConfig
extends PhaseConfig<LocalSearchPhaseConfig> {
    protected LocalSearchType localSearchType = null;
    @XStreamImplicit
    private List<MoveSelectorConfig> moveSelectorConfigList = null;
    @XStreamAlias(value="acceptor")
    private AcceptorConfig acceptorConfig = null;
    @XStreamAlias(value="forager")
    private LocalSearchForagerConfig foragerConfig = null;

    public LocalSearchType getLocalSearchType() {
        return this.localSearchType;
    }

    public void setLocalSearchType(LocalSearchType localSearchType) {
        this.localSearchType = localSearchType;
    }

    public MoveSelectorConfig getMoveSelectorConfig() {
        return this.moveSelectorConfigList == null ? null : this.moveSelectorConfigList.get(0);
    }

    public void setMoveSelectorConfig(MoveSelectorConfig moveSelectorConfig) {
        this.moveSelectorConfigList = moveSelectorConfig == null ? null : Collections.singletonList(moveSelectorConfig);
    }

    public AcceptorConfig getAcceptorConfig() {
        return this.acceptorConfig;
    }

    public void setAcceptorConfig(AcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
    }

    public LocalSearchForagerConfig getForagerConfig() {
        return this.foragerConfig;
    }

    public void setForagerConfig(LocalSearchForagerConfig foragerConfig) {
        this.foragerConfig = foragerConfig;
    }

    public LocalSearchPhaseConfig withLocalSearchType(LocalSearchType localSearchType) {
        this.localSearchType = localSearchType;
        return this;
    }

    public LocalSearchPhaseConfig withMoveSelectorConfig(MoveSelectorConfig moveSelectorConfig) {
        this.moveSelectorConfigList = moveSelectorConfig == null ? null : Collections.singletonList(moveSelectorConfig);
        return this;
    }

    public LocalSearchPhaseConfig withAcceptorConfig(AcceptorConfig acceptorConfig) {
        this.acceptorConfig = acceptorConfig;
        return this;
    }

    public LocalSearchPhaseConfig withForagerConfig(LocalSearchForagerConfig foragerConfig) {
        this.foragerConfig = foragerConfig;
        return this;
    }

    @Override
    public LocalSearchPhase buildPhase(int phaseIndex, HeuristicConfigPolicy solverConfigPolicy, BestSolutionRecaller bestSolutionRecaller, Termination solverTermination) {
        HeuristicConfigPolicy phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        DefaultLocalSearchPhase phase = new DefaultLocalSearchPhase(phaseIndex, solverConfigPolicy.getLogIndentation(), bestSolutionRecaller, this.buildPhaseTermination(phaseConfigPolicy, solverTermination));
        phase.setDecider(this.buildDecider(phaseConfigPolicy, phase.getTermination()));
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            phase.setAssertStepScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            phase.setAssertExpectedStepScore(true);
            phase.setAssertShadowVariablesAreNotStaleAfterStep(true);
        }
        return phase;
    }

    private LocalSearchDecider buildDecider(HeuristicConfigPolicy configPolicy, Termination termination) {
        LocalSearchDecider decider;
        MoveSelector moveSelector = this.buildMoveSelector(configPolicy);
        Acceptor acceptor = this.buildAcceptor(configPolicy);
        LocalSearchForager forager = this.buildForager(configPolicy);
        if (moveSelector.isNeverEnding() && !forager.supportsNeverEndingMoveSelector()) {
            throw new IllegalStateException("The moveSelector (" + moveSelector + ") has neverEnding (" + moveSelector.isNeverEnding() + "), but the forager (" + forager + ") does not support it.\nMaybe configure the <forager> with an <acceptedCountLimit>.");
        }
        Integer moveThreadCount = configPolicy.getMoveThreadCount();
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        if (moveThreadCount == null) {
            decider = new LocalSearchDecider(configPolicy.getLogIndentation(), termination, moveSelector, acceptor, forager);
        } else {
            Integer moveThreadBufferSize = configPolicy.getMoveThreadBufferSize();
            if (moveThreadBufferSize == null) {
                moveThreadBufferSize = 10;
            }
            ThreadFactory threadFactory = configPolicy.buildThreadFactory(ChildThreadType.MOVE_THREAD);
            int selectedMoveBufferSize = moveThreadCount * moveThreadBufferSize;
            MultiThreadedLocalSearchDecider multiThreadedDecider = new MultiThreadedLocalSearchDecider(configPolicy.getLogIndentation(), termination, moveSelector, acceptor, forager, threadFactory, moveThreadCount, selectedMoveBufferSize);
            if (environmentMode.isNonIntrusiveFullAsserted()) {
                multiThreadedDecider.setAssertStepScoreFromScratch(true);
            }
            if (environmentMode.isIntrusiveFastAsserted()) {
                multiThreadedDecider.setAssertExpectedStepScore(true);
                multiThreadedDecider.setAssertShadowVariablesAreNotStaleAfterStep(true);
            }
            decider = multiThreadedDecider;
        }
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            decider.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            decider.setAssertExpectedUndoMoveScore(true);
        }
        return decider;
    }

    protected Acceptor buildAcceptor(HeuristicConfigPolicy configPolicy) {
        AcceptorConfig acceptorConfig_;
        if (this.acceptorConfig != null) {
            if (this.localSearchType != null) {
                throw new IllegalArgumentException("The localSearchType (" + (Object)((Object)this.localSearchType) + ") must not be configured if the acceptorConfig (" + this.acceptorConfig + ") is explicitly configured.");
            }
            acceptorConfig_ = this.acceptorConfig;
        } else {
            LocalSearchType localSearchType_ = (LocalSearchType)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.localSearchType), (Object)((Object)LocalSearchType.LATE_ACCEPTANCE)));
            acceptorConfig_ = new AcceptorConfig();
            switch (localSearchType_) {
                case HILL_CLIMBING: 
                case VARIABLE_NEIGHBORHOOD_DESCENT: {
                    acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.HILL_CLIMBING));
                    break;
                }
                case TABU_SEARCH: {
                    acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.ENTITY_TABU));
                    break;
                }
                case SIMULATED_ANNEALING: {
                    acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.SIMULATED_ANNEALING));
                    break;
                }
                case LATE_ACCEPTANCE: {
                    acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.LATE_ACCEPTANCE));
                    break;
                }
                case GREAT_DELUGE: {
                    acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.GREAT_DELUGE));
                    break;
                }
                default: {
                    throw new IllegalStateException("The localSearchType (" + (Object)((Object)localSearchType_) + ") is not implemented.");
                }
            }
        }
        return acceptorConfig_.buildAcceptor(configPolicy);
    }

    protected LocalSearchForager buildForager(HeuristicConfigPolicy configPolicy) {
        LocalSearchForagerConfig foragerConfig_;
        if (this.foragerConfig != null) {
            if (this.localSearchType != null) {
                throw new IllegalArgumentException("The localSearchType (" + (Object)((Object)this.localSearchType) + ") must not be configured if the foragerConfig (" + this.foragerConfig + ") is explicitly configured.");
            }
            foragerConfig_ = this.foragerConfig;
        } else {
            LocalSearchType localSearchType_ = (LocalSearchType)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.localSearchType), (Object)((Object)LocalSearchType.LATE_ACCEPTANCE)));
            foragerConfig_ = new LocalSearchForagerConfig();
            switch (localSearchType_) {
                case HILL_CLIMBING: {
                    foragerConfig_.setAcceptedCountLimit(1);
                    break;
                }
                case TABU_SEARCH: {
                    foragerConfig_.setAcceptedCountLimit(1000);
                    break;
                }
                case SIMULATED_ANNEALING: 
                case LATE_ACCEPTANCE: 
                case GREAT_DELUGE: {
                    foragerConfig_.setAcceptedCountLimit(1);
                    break;
                }
                case VARIABLE_NEIGHBORHOOD_DESCENT: {
                    foragerConfig_.setPickEarlyType(LocalSearchPickEarlyType.FIRST_LAST_STEP_SCORE_IMPROVING);
                    break;
                }
                default: {
                    throw new IllegalStateException("The localSearchType (" + (Object)((Object)localSearchType_) + ") is not implemented.");
                }
            }
        }
        return foragerConfig_.buildForager(configPolicy);
    }

    protected MoveSelector buildMoveSelector(HeuristicConfigPolicy configPolicy) {
        MoveSelector moveSelector;
        SelectionCacheType defaultCacheType = SelectionCacheType.JUST_IN_TIME;
        SelectionOrder defaultSelectionOrder = this.localSearchType == LocalSearchType.VARIABLE_NEIGHBORHOOD_DESCENT ? SelectionOrder.ORIGINAL : SelectionOrder.RANDOM;
        if (ConfigUtils.isEmptyCollection(this.moveSelectorConfigList)) {
            UnionMoveSelectorConfig unionMoveSelectorConfig = new UnionMoveSelectorConfig();
            unionMoveSelectorConfig.setMoveSelectorConfigList(Arrays.asList(new ChangeMoveSelectorConfig(), new SwapMoveSelectorConfig()));
            moveSelector = unionMoveSelectorConfig.buildMoveSelector(configPolicy, defaultCacheType, defaultSelectionOrder);
        } else if (this.moveSelectorConfigList.size() == 1) {
            moveSelector = this.moveSelectorConfigList.get(0).buildMoveSelector(configPolicy, defaultCacheType, defaultSelectionOrder);
        } else {
            throw new IllegalArgumentException("The moveSelectorConfigList (" + this.moveSelectorConfigList + ") must be a singleton or empty. Use a single " + UnionMoveSelectorConfig.class.getSimpleName() + " or " + CartesianProductMoveSelectorConfig.class.getSimpleName() + " element to nest multiple MoveSelectors.");
        }
        return moveSelector;
    }

    @Override
    public void inherit(LocalSearchPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.localSearchType = ConfigUtils.inheritOverwritableProperty(this.localSearchType, inheritedConfig.getLocalSearchType());
        this.setMoveSelectorConfig(ConfigUtils.inheritOverwritableProperty(this.getMoveSelectorConfig(), inheritedConfig.getMoveSelectorConfig()));
        this.acceptorConfig = ConfigUtils.inheritConfig(this.acceptorConfig, inheritedConfig.getAcceptorConfig());
        this.foragerConfig = ConfigUtils.inheritConfig(this.foragerConfig, inheritedConfig.getForagerConfig());
    }
}

