/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream.uni;

import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.NoneBiJoiner;

public interface UniConstraintStream<A>
extends ConstraintStream {
    public UniConstraintStream<A> filter(Predicate<A> var1);

    default public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream) {
        return this.join(otherStream, new NoneBiJoiner());
    }

    public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> var1, BiJoiner<A, B> var2);

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass) {
        return this.join(otherClass, (BiJoiner<A, B>)new NoneBiJoiner());
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner) {
        return this.join(this.getConstraintFactory().from(otherClass), joiner);
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2) {
        return this.join(otherClass, (BiJoiner<A, B>)AbstractBiJoiner.merge(joiner1, joiner2));
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3) {
        return this.join(otherClass, (BiJoiner<A, B>)AbstractBiJoiner.merge(joiner1, joiner2, joiner3));
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> joiner1, BiJoiner<A, B> joiner2, BiJoiner<A, B> joiner3, BiJoiner<A, B> joiner4) {
        return this.join(otherClass, (BiJoiner<A, B>)AbstractBiJoiner.merge(joiner1, joiner2, joiner3, joiner4));
    }

    default public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        return this.join(otherClass, (BiJoiner<A, B>)AbstractBiJoiner.merge(joiners));
    }

    public <GroupKey_, ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(UniConstraintCollector<A, ResultContainer_, Result_> var1);

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(Function<A, GroupKey_> var1);

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(Function<A, GroupKey_> var1, UniConstraintCollector<A, ResultContainer_, Result_> var2);

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2);

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(Function<A, GroupKeyA_> var1, Function<A, GroupKeyB_> var2, UniConstraintCollector<A, ResultContainer_, Result_> var3);

    default public Constraint penalize(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.penalize(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalize(String var1, String var2, Score<?> var3, ToIntFunction<A> var4);

    default public Constraint penalizeLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.penalizeLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalizeLong(String var1, String var2, Score<?> var3, ToLongFunction<A> var4);

    default public Constraint penalizeBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalizeBigDecimal(String var1, String var2, Score<?> var3, Function<A, BigDecimal> var4);

    default public Constraint penalizeConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.penalizeConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurable(String var1, String var2, ToIntFunction<A> var3);

    default public Constraint penalizeConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.penalizeConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurableLong(String var1, String var2, ToLongFunction<A> var3);

    default public Constraint penalizeConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurableBigDecimal(String var1, String var2, Function<A, BigDecimal> var3);

    default public Constraint reward(String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher) {
        return this.reward(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint reward(String var1, String var2, Score<?> var3, ToIntFunction<A> var4);

    default public Constraint rewardLong(String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher) {
        return this.rewardLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint rewardLong(String var1, String var2, Score<?> var3, ToLongFunction<A> var4);

    default public Constraint rewardBigDecimal(String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint rewardBigDecimal(String var1, String var2, Score<?> var3, Function<A, BigDecimal> var4);

    default public Constraint rewardConfigurable(String constraintName, ToIntFunction<A> matchWeigher) {
        return this.rewardConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurable(String var1, String var2, ToIntFunction<A> var3);

    default public Constraint rewardConfigurableLong(String constraintName, ToLongFunction<A> matchWeigher) {
        return this.rewardConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurableLong(String var1, String var2, ToLongFunction<A> var3);

    default public Constraint rewardConfigurableBigDecimal(String constraintName, Function<A, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurableBigDecimal(String var1, String var2, Function<A, BigDecimal> var3);
}

