/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.optaplanner.core.api.domain.solution.cloner.SolutionCloner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchScoreComparator;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.lookup.ClassAndPlanningIdComparator;
import org.optaplanner.core.impl.domain.lookup.LookUpManager;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerSupport;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirector<Solution_, Factory_ extends AbstractScoreDirectorFactory<Solution_>>
implements InnerScoreDirector<Solution_>,
Cloneable {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Factory_ scoreDirectorFactory;
    protected final boolean lookUpEnabled;
    protected final LookUpManager lookUpManager;
    protected boolean constraintMatchEnabledPreference;
    protected final VariableListenerSupport<Solution_> variableListenerSupport;
    protected Solution_ workingSolution;
    protected long workingEntityListRevision = 0L;
    protected Integer workingInitScore = null;
    protected boolean allChangesWillBeUndoneBeforeStepEnds = false;
    protected long calculationCount = 0L;

    protected AbstractScoreDirector(Factory_ scoreDirectorFactory, boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        this.scoreDirectorFactory = scoreDirectorFactory;
        this.lookUpEnabled = lookUpEnabled;
        this.lookUpManager = lookUpEnabled ? new LookUpManager(((AbstractScoreDirectorFactory)scoreDirectorFactory).getSolutionDescriptor().getLookUpStrategyResolver()) : null;
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
        this.variableListenerSupport = new VariableListenerSupport(this);
        this.variableListenerSupport.linkVariableListeners();
    }

    public Factory_ getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getScoreDefinition();
    }

    public boolean isLookUpEnabled() {
        return this.lookUpEnabled;
    }

    public boolean isConstraintMatchEnabledPreference() {
        return this.constraintMatchEnabledPreference;
    }

    @Override
    public void overwriteConstraintMatchEnabledPreference(boolean constraintMatchEnabledPreference) {
        this.constraintMatchEnabledPreference = constraintMatchEnabledPreference;
    }

    @Override
    public Solution_ getWorkingSolution() {
        return this.workingSolution;
    }

    @Override
    public long getWorkingEntityListRevision() {
        return this.workingEntityListRevision;
    }

    public boolean isAllChangesWillBeUndoneBeforeStepEnds() {
        return this.allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public void setAllChangesWillBeUndoneBeforeStepEnds(boolean allChangesWillBeUndoneBeforeStepEnds) {
        this.allChangesWillBeUndoneBeforeStepEnds = allChangesWillBeUndoneBeforeStepEnds;
    }

    @Override
    public long getCalculationCount() {
        return this.calculationCount;
    }

    @Override
    public void resetCalculationCount() {
        this.calculationCount = 0L;
    }

    @Override
    public SupplyManager getSupplyManager() {
        return this.variableListenerSupport;
    }

    @Override
    public void setWorkingSolution(Solution_ workingSolution) {
        this.workingSolution = workingSolution;
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        this.workingInitScore = -solutionDescriptor.countUninitializedVariables(workingSolution);
        if (this.lookUpEnabled) {
            this.lookUpManager.resetWorkingObjects(solutionDescriptor.getAllFacts(workingSolution));
        }
        this.variableListenerSupport.resetWorkingSolution();
        this.setWorkingEntityListDirty();
    }

    @Override
    public Score doAndProcessMove(Move<Solution_> move, boolean assertMoveScoreFromScratch) {
        Move<Solution_> undoMove = move.doMove(this);
        Score score = this.calculateScore();
        if (assertMoveScoreFromScratch) {
            this.assertWorkingScoreFromScratch(score, move);
        }
        undoMove.doMove(this);
        return score;
    }

    @Override
    public void doAndProcessMove(Move<Solution_> move, boolean assertMoveScoreFromScratch, Consumer<Score> moveProcessor) {
        Move<Solution_> undoMove = move.doMove(this);
        Score score = this.calculateScore();
        if (assertMoveScoreFromScratch) {
            this.assertWorkingScoreFromScratch(score, move);
        }
        moveProcessor.accept(score);
        undoMove.doMove(this);
    }

    @Override
    public boolean isWorkingEntityListDirty(long expectedWorkingEntityListRevision) {
        return this.workingEntityListRevision != expectedWorkingEntityListRevision;
    }

    protected void setWorkingEntityListDirty() {
        ++this.workingEntityListRevision;
    }

    @Override
    public Solution_ cloneWorkingSolution() {
        return this.cloneSolution(this.workingSolution);
    }

    @Override
    public Solution_ cloneSolution(Solution_ originalSolution) {
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        Score originalScore = solutionDescriptor.getScore(originalSolution);
        Solution_ cloneSolution = solutionDescriptor.getSolutionCloner().cloneSolution(originalSolution);
        Score cloneScore = solutionDescriptor.getScore(cloneSolution);
        if (((AbstractScoreDirectorFactory)this.scoreDirectorFactory).isAssertClonedSolution()) {
            if (!Objects.equals(originalScore, cloneScore)) {
                throw new IllegalStateException("Cloning corruption: the original's score (" + originalScore + ") is different from the clone's score (" + cloneScore + ").\nCheck the " + SolutionCloner.class.getSimpleName() + ".");
            }
            List<Object> originalEntityList = solutionDescriptor.getEntityList(originalSolution);
            IdentityHashMap originalEntityMap = new IdentityHashMap(originalEntityList.size());
            for (Object originalEntity : originalEntityList) {
                originalEntityMap.put(originalEntity, null);
            }
            for (Object cloneEntity : solutionDescriptor.getEntityList(cloneSolution)) {
                if (!originalEntityMap.containsKey(cloneEntity)) continue;
                throw new IllegalStateException("Cloning corruption: the same entity (" + cloneEntity + ") is present in both the original and the clone.\nSo when a planning variable in the original solution changes, the cloned solution will change too.\nCheck the " + SolutionCloner.class.getSimpleName() + ".");
            }
        }
        return cloneSolution;
    }

    @Override
    public int getWorkingEntityCount() {
        return this.getSolutionDescriptor().getEntityCount(this.workingSolution);
    }

    @Override
    public List<Object> getWorkingEntityList() {
        return this.getSolutionDescriptor().getEntityList(this.workingSolution);
    }

    @Override
    public int getWorkingValueCount() {
        return this.getSolutionDescriptor().getValueCount(this.workingSolution);
    }

    @Override
    public void triggerVariableListeners() {
        this.variableListenerSupport.triggerVariableListenersInNotificationQueues();
    }

    protected void setCalculatedScore(Score score) {
        this.getSolutionDescriptor().setScore(this.workingSolution, score);
        ++this.calculationCount;
    }

    @Override
    public String explainScore() {
        int INDICTMENT_LIMIT = 5;
        int CONSTRAINT_MATCH_LIMIT = 2;
        Score workingScore = this.calculateScore();
        Collection<ConstraintMatchTotal> constraintMatchTotals = this.getConstraintMatchTotals();
        ConstraintMatchScoreComparator constraintMatchScoreComparator = new ConstraintMatchScoreComparator();
        StringBuilder scoreExplanation = new StringBuilder((constraintMatchTotals.size() + 4 + 10) * 80);
        scoreExplanation.append("Explanation of score (").append(workingScore).append("):\n");
        scoreExplanation.append("    Constraint match totals:\n");
        Comparator<ConstraintMatchTotal> constraintMatchTotalComparator = Comparator.comparing(ConstraintMatchTotal::getScore);
        Comparator<ConstraintMatch> constraintMatchComparator = Comparator.comparing(ConstraintMatch::getScore);
        constraintMatchTotals.stream().sorted(constraintMatchTotalComparator).forEach(constraintMatchTotal -> {
            Set<ConstraintMatch> constraintMatchSet = constraintMatchTotal.getConstraintMatchSet();
            scoreExplanation.append("        ").append(constraintMatchTotal.getScore().toShortString()).append(": constraint (").append(constraintMatchTotal.getConstraintName()).append(") has ").append(constraintMatchSet.size()).append(" matches:\n");
            constraintMatchSet.stream().sorted(constraintMatchComparator).limit(2L).forEach(constraintMatch -> scoreExplanation.append("            ").append(constraintMatch.getScore().toShortString()).append(": justifications (").append(constraintMatch.getJustificationList()).append(")\n"));
            if (constraintMatchSet.size() > 2) {
                scoreExplanation.append("            ...\n");
            }
        });
        Collection<Indictment> indictments = this.getIndictmentMap().values();
        scoreExplanation.append("    Indictments (top ").append(5).append(" of ").append(indictments.size()).append("):\n");
        Comparator<Indictment> indictmentComparator = Comparator.comparing(Indictment::getScore);
        indictments.stream().sorted(indictmentComparator).limit(5L).forEach(indictment -> {
            Set<ConstraintMatch> constraintMatchSet = indictment.getConstraintMatchSet();
            scoreExplanation.append("        ").append(indictment.getScore().toShortString()).append(": justification (").append(indictment.getJustification()).append(") has ").append(constraintMatchSet.size()).append(" matches:\n");
            constraintMatchSet.stream().sorted(constraintMatchScoreComparator).limit(2L).forEach(constraintMatch -> scoreExplanation.append("            ").append(constraintMatch.getScore().toShortString()).append(": constraint (").append(constraintMatch.getConstraintName()).append(")\n"));
            if (constraintMatchSet.size() > 2) {
                scoreExplanation.append("            ...\n");
            }
        });
        if (indictments.size() > 5) {
            scoreExplanation.append("        ...\n");
        }
        return scoreExplanation.toString();
    }

    public AbstractScoreDirector<Solution_, Factory_> clone() {
        AbstractScoreDirector clone = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector(this.isLookUpEnabled(), this.constraintMatchEnabledPreference);
        clone.setWorkingSolution(this.cloneWorkingSolution());
        return clone;
    }

    @Override
    public InnerScoreDirector<Solution_> createChildThreadScoreDirector(ChildThreadType childThreadType) {
        if (childThreadType == ChildThreadType.PART_THREAD) {
            AbstractScoreDirector childThreadScoreDirector = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector(this.isLookUpEnabled(), this.constraintMatchEnabledPreference);
            childThreadScoreDirector.calculationCount = this.calculationCount;
            return childThreadScoreDirector;
        }
        if (childThreadType == ChildThreadType.MOVE_THREAD) {
            AbstractScoreDirector childThreadScoreDirector = (AbstractScoreDirector)this.scoreDirectorFactory.buildScoreDirector(true, this.constraintMatchEnabledPreference);
            childThreadScoreDirector.setWorkingSolution(this.cloneWorkingSolution());
            return childThreadScoreDirector;
        }
        throw new IllegalStateException("The childThreadType (" + (Object)((Object)childThreadType) + ") is not implemented.");
    }

    @Override
    public void close() {
        this.workingSolution = null;
        this.workingInitScore = null;
        if (this.lookUpEnabled) {
            this.lookUpManager.clearWorkingObjects();
        }
        this.variableListenerSupport.clearWorkingSolution();
    }

    @Override
    public final void beforeEntityAdded(Object entity) {
        this.beforeEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityAdded(Object entity) {
        this.afterEntityAdded(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void beforeVariableChanged(Object entity, String variableName) {
        VariableDescriptor<Solution_> variableDescriptor = this.getSolutionDescriptor().findVariableDescriptorOrFail(entity, variableName);
        this.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final void afterVariableChanged(Object entity, String variableName) {
        VariableDescriptor<Solution_> variableDescriptor = this.getSolutionDescriptor().findVariableDescriptorOrFail(entity, variableName);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final void beforeEntityRemoved(Object entity) {
        this.beforeEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    @Override
    public final void afterEntityRemoved(Object entity) {
        this.afterEntityRemoved(this.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass()), entity);
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.variableListenerSupport.beforeEntityAdded(entityDescriptor, entity);
    }

    public void afterEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore = this.workingInitScore - entityDescriptor.countUninitializedVariables(entity);
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(entity);
        }
        this.variableListenerSupport.afterEntityAdded(entityDescriptor, entity);
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            Integer n = this.workingInitScore;
            Integer n2 = this.workingInitScore = Integer.valueOf(this.workingInitScore + 1);
        }
        this.variableListenerSupport.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor variableDescriptor, Object entity) {
        if (variableDescriptor.isGenuineAndUninitialized(entity)) {
            Integer n = this.workingInitScore;
            Integer n2 = this.workingInitScore = Integer.valueOf(this.workingInitScore - 1);
        }
        this.variableListenerSupport.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void changeVariableFacade(VariableDescriptor variableDescriptor, Object entity, Object newValue) {
        this.beforeVariableChanged(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        this.workingInitScore = this.workingInitScore + entityDescriptor.countUninitializedVariables(entity);
        this.variableListenerSupport.beforeEntityRemoved(entityDescriptor, entity);
    }

    public void afterEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(entity);
        }
        this.variableListenerSupport.afterEntityRemoved(entityDescriptor, entity);
        if (!this.allChangesWillBeUndoneBeforeStepEnds) {
            this.setWorkingEntityListDirty();
        }
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.addWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public void beforeProblemPropertyChanged(Object problemFactOrEntity) {
    }

    @Override
    public void afterProblemPropertyChanged(Object problemFactOrEntity) {
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        if (this.lookUpEnabled) {
            this.lookUpManager.removeWorkingObject(problemFact);
        }
        this.variableListenerSupport.resetWorkingSolution();
    }

    @Override
    public <E> E lookUpWorkingObject(E externalObject) {
        if (!this.lookUpEnabled) {
            throw new IllegalStateException("When lookUpEnabled (" + this.lookUpEnabled + ") is disabled in the constructor, this method should not be called.");
        }
        return this.lookUpManager.lookUpWorkingObject(externalObject);
    }

    @Override
    public <E> E lookUpWorkingObjectOrReturnNull(E externalObject) {
        if (!this.lookUpEnabled) {
            throw new IllegalStateException("When lookUpEnabled (" + this.lookUpEnabled + ") is disabled in the constructor, this method should not be called.");
        }
        return this.lookUpManager.lookUpWorkingObjectOrReturnNull(externalObject);
    }

    @Override
    public void assertExpectedWorkingScore(Score expectedWorkingScore, Object completedAction) {
        Score workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            throw new IllegalStateException("Score corruption (" + expectedWorkingScore.subtract(workingScore).toShortString() + "): the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore (" + workingScore + ") after completedAction (" + completedAction + ").");
        }
    }

    @Override
    public void assertShadowVariablesAreNotStale(Score expectedWorkingScore, Object completedAction) {
        String violationMessage = this.createShadowVariablesViolationMessage();
        if (violationMessage != null) {
            throw new IllegalStateException(VariableListener.class.getSimpleName() + " corruption after completedAction (" + completedAction + "):\n" + violationMessage);
        }
        Score workingScore = this.calculateScore();
        if (!expectedWorkingScore.equals(workingScore)) {
            this.assertWorkingScoreFromScratch(workingScore, "assertShadowVariablesAreNotStale(" + expectedWorkingScore + ", " + completedAction + ")");
            throw new IllegalStateException("Impossible " + VariableListener.class.getSimpleName() + " corruption (" + expectedWorkingScore.subtract(workingScore).toShortString() + "): the expectedWorkingScore (" + expectedWorkingScore + ") is not the workingScore (" + workingScore + ") after all " + VariableListener.class.getSimpleName() + "s were triggered without changes to the genuine variables after completedAction (" + completedAction + ").\nBut all the shadow variable values are still the same, so this is impossible.\nMaybe run with " + (Object)((Object)EnvironmentMode.FULL_ASSERT) + " if you aren't already, to fail earlier.");
        }
    }

    protected String buildShadowVariableAnalysis(boolean predicted) {
        String workingLabel;
        String violationMessage = this.createShadowVariablesViolationMessage();
        String string = workingLabel = predicted ? "working" : "corrupted";
        if (violationMessage == null) {
            return "Shadow variable corruption in the " + workingLabel + " scoreDirector:\n  None";
        }
        return "Shadow variable corruption in the " + workingLabel + " scoreDirector:\n" + violationMessage + "  Maybe there is a bug in the VariableListener of those shadow variable(s).";
    }

    protected String createShadowVariablesViolationMessage() {
        Map<ShadowVariableDescriptor<Solution_>, Object> shadowVariableValuesMap;
        Collection<ShadowVariableDescriptor<Solution_>> shadowVariableDescriptors;
        EntityDescriptor<Solution_> entityDescriptor;
        Object entity;
        TreeMap<ShadowVariableDescriptor, List> violationListMap = new TreeMap<ShadowVariableDescriptor, List>(Comparator.comparing(ShadowVariableDescriptor::getGlobalShadowOrder));
        SolutionDescriptor<Solution_> solutionDescriptor = this.getSolutionDescriptor();
        IdentityHashMap entityToShadowVariableValuesMap = new IdentityHashMap();
        Iterator<Object> it = solutionDescriptor.extractAllEntitiesIterator(this.workingSolution);
        while (it.hasNext()) {
            entity = it.next();
            entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            shadowVariableDescriptors = entityDescriptor.getShadowVariableDescriptors();
            shadowVariableValuesMap = new HashMap(shadowVariableDescriptors.size());
            for (ShadowVariableDescriptor<Solution_> shadowVariableDescriptor2 : shadowVariableDescriptors) {
                Object value = shadowVariableDescriptor2.getValue(entity);
                shadowVariableValuesMap.put(shadowVariableDescriptor2, value);
            }
            entityToShadowVariableValuesMap.put(entity, shadowVariableValuesMap);
        }
        this.variableListenerSupport.triggerAllVariableListeners();
        it = solutionDescriptor.extractAllEntitiesIterator(this.workingSolution);
        while (it.hasNext()) {
            entity = it.next();
            entityDescriptor = solutionDescriptor.findEntityDescriptorOrFail(entity.getClass());
            shadowVariableDescriptors = entityDescriptor.getShadowVariableDescriptors();
            shadowVariableValuesMap = (Map)entityToShadowVariableValuesMap.get(entity);
            for (ShadowVariableDescriptor<Solution_> shadowVariableDescriptor2 : shadowVariableDescriptors) {
                Object newValue = shadowVariableDescriptor2.getValue(entity);
                Object originalValue = shadowVariableValuesMap.get(shadowVariableDescriptor2);
                if (Objects.equals(originalValue, newValue)) continue;
                List violationList2 = violationListMap.computeIfAbsent(shadowVariableDescriptor2, k -> new ArrayList());
                violationList2.add("    The entity (" + entity + ")'s shadow variable (" + shadowVariableDescriptor2.getSimpleEntityAndVariableName() + ")'s corrupted value (" + originalValue + ") changed to uncorrupted value (" + newValue + ") after all " + VariableListener.class.getSimpleName() + "s were triggered without changes to the genuine variables.\n      Maybe the " + VariableListener.class.getSimpleName() + " class (" + shadowVariableDescriptor2.getVariableListenerClass().getSimpleName() + ") for that shadow variable (" + shadowVariableDescriptor2.getSimpleEntityAndVariableName() + ") forgot to update it when one of its sources changed.\n");
            }
        }
        if (violationListMap.isEmpty()) {
            return null;
        }
        int SHADOW_VARIABLE_VIOLATION_DISPLAY_LIMIT = 3;
        StringBuilder message = new StringBuilder();
        violationListMap.forEach((shadowVariableDescriptor, violationList) -> {
            violationList.stream().limit(3L).forEach(message::append);
            if (violationList.size() >= 3) {
                message.append("  ... ").append(violationList.size() - 3).append(" more\n");
            }
        });
        return message.toString();
    }

    @Override
    public void assertWorkingScoreFromScratch(Score workingScore, Object completedAction) {
        this.assertScoreFromScratch(workingScore, completedAction, false);
    }

    @Override
    public void assertPredictedScoreFromScratch(Score workingScore, Object completedAction) {
        this.assertScoreFromScratch(workingScore, completedAction, true);
    }

    private void assertScoreFromScratch(Score score, Object completedAction, boolean predicted) {
        InnerScoreDirectorFactory<Object> assertionScoreDirectorFactory = ((AbstractScoreDirectorFactory)this.scoreDirectorFactory).getAssertionScoreDirectorFactory();
        if (assertionScoreDirectorFactory == null) {
            assertionScoreDirectorFactory = this.scoreDirectorFactory;
        }
        try (InnerScoreDirector<Solution_> uncorruptedScoreDirector = assertionScoreDirectorFactory.buildScoreDirector(false, true);){
            uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
            Score uncorruptedScore = uncorruptedScoreDirector.calculateScore();
            if (!score.equals(uncorruptedScore)) {
                String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector, predicted);
                String shadowVariableAnalysis = this.buildShadowVariableAnalysis(predicted);
                throw new IllegalStateException("Score corruption (" + score.subtract(uncorruptedScore).toShortString() + "): the " + (predicted ? "predictedScore" : "workingScore") + " (" + score + ") is not the uncorruptedScore (" + uncorruptedScore + ") after completedAction (" + completedAction + "):\n" + scoreCorruptionAnalysis + "\n" + shadowVariableAnalysis);
            }
        }
    }

    @Override
    public void assertExpectedUndoMoveScore(Move move, Score beforeMoveScore) {
        Score undoScore = this.calculateScore();
        if (!undoScore.equals(beforeMoveScore)) {
            this.logger.trace("        Corruption detected. Diagnosing...");
            String undoMoveString = "Undo(" + move + ")";
            this.assertWorkingScoreFromScratch(undoScore, undoMoveString);
            this.assertShadowVariablesAreNotStale(undoScore, undoMoveString);
            String scoreDifference = undoScore.subtract(beforeMoveScore).toShortString();
            throw new IllegalStateException("UndoMove corruption (" + scoreDifference + "): the beforeMoveScore (" + beforeMoveScore + ") is not the undoScore (" + undoScore + ") which is the uncorruptedScore (" + undoScore + ") of the workingSolution.\n  1) Enable EnvironmentMode " + (Object)((Object)EnvironmentMode.FULL_ASSERT) + " (if you haven't already) to fail-faster in case there's a score corruption or variable listener corruption.\n  2) Check the Move.createUndoMove(...) method of the moveClass (" + move.getClass() + "). The move (" + move + ") might have a corrupted undoMove (" + undoMoveString + ").\n  3) Check your custom " + VariableListener.class.getSimpleName() + "s (if you have any) for shadow variables that are used by score constraints that could cause the scoreDifference (" + scoreDifference + ").");
        }
    }

    protected String buildScoreCorruptionAnalysis(ScoreDirector<Solution_> uncorruptedScoreDirector, boolean predicted) {
        String workingLabel;
        if (!this.isConstraintMatchEnabled() || !uncorruptedScoreDirector.isConstraintMatchEnabled()) {
            return "Score corruption analysis could not be generated because either corrupted constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") or uncorrupted constraintMatchEnabled (" + uncorruptedScoreDirector.isConstraintMatchEnabled() + ") is disabled.\n  Check your score constraints manually.";
        }
        Collection<ConstraintMatchTotal> corruptedConstraintMatchTotals = this.getConstraintMatchTotals();
        Collection<ConstraintMatchTotal> uncorruptedConstraintMatchTotals = uncorruptedScoreDirector.getConstraintMatchTotals();
        ClassAndPlanningIdComparator comparator = new ClassAndPlanningIdComparator(false);
        for (ConstraintMatchTotal constraintMatchTotal : corruptedConstraintMatchTotals) {
            for (ConstraintMatch constraintMatch2 : constraintMatchTotal.getConstraintMatchSet()) {
                constraintMatch2.getJustificationList().sort(comparator);
            }
        }
        for (ConstraintMatchTotal constraintMatchTotal : uncorruptedConstraintMatchTotals) {
            for (ConstraintMatch constraintMatch2 : constraintMatchTotal.getConstraintMatchSet()) {
                constraintMatch2.getJustificationList().sort(comparator);
            }
        }
        Map<List<Object>, ConstraintMatch> corruptedMap = this.createConstraintMatchMap(corruptedConstraintMatchTotals);
        LinkedHashMap<List<Object>, ConstraintMatch> excessMap = new LinkedHashMap<List<Object>, ConstraintMatch>(corruptedMap);
        Map<List<Object>, ConstraintMatch> missingMap = this.createConstraintMatchMap(uncorruptedConstraintMatchTotals);
        excessMap.keySet().removeAll(missingMap.keySet());
        missingMap.keySet().removeAll(corruptedMap.keySet());
        int CONSTRAINT_MATCH_DISPLAY_LIMIT = 8;
        StringBuilder analysis = new StringBuilder();
        analysis.append("Score corruption analysis:\n");
        String string = workingLabel = predicted ? "working" : "corrupted";
        if (excessMap.isEmpty()) {
            analysis.append("  The ").append(workingLabel).append(" scoreDirector has no ConstraintMatch(s) which are in excess.\n");
        } else {
            analysis.append("  The ").append(workingLabel).append(" scoreDirector has ").append(excessMap.size()).append(" ConstraintMatch(s) which are in excess (and should not be there):\n");
            excessMap.values().stream().sorted().limit(8L).forEach(constraintMatch -> analysis.append("    ").append(constraintMatch).append("\n"));
            if (excessMap.size() >= 8) {
                analysis.append("    ... ").append(excessMap.size() - 8).append(" more\n");
            }
        }
        if (missingMap.isEmpty()) {
            analysis.append("  The ").append(workingLabel).append(" scoreDirector has no ConstraintMatch(s) which are missing.\n");
        } else {
            analysis.append("  The ").append(workingLabel).append(" scoreDirector has ").append(missingMap.size()).append(" ConstraintMatch(s) which are missing:\n");
            missingMap.values().stream().sorted().limit(8L).forEach(constraintMatch -> analysis.append("    ").append(constraintMatch).append("\n"));
            if (missingMap.size() >= 8) {
                analysis.append("    ... ").append(missingMap.size() - 8).append(" more\n");
            }
        }
        if (!excessMap.isEmpty() || !missingMap.isEmpty()) {
            analysis.append("  Maybe there is a bug in the score constraints of those ConstraintMatch(s).\n");
            analysis.append("  Maybe a score constraint doesn't select all the entities it depends on, but finds some through a reference in a selected entity. This corrupts incremental score calculation, because the constraint is not re-evaluated if such a non-selected entity changes.");
        } else if (predicted) {
            analysis.append("  If multithreaded solving is active, the working scoreDirector is probably not the corrupted scoreDirector.\n");
            analysis.append("  If multithreaded solving is active, maybe the rebase() method of the move is bugged.\n");
            analysis.append("  If multithreaded solving is active, maybe a VariableListener affected the moveThread's workingSolution after doing and undoing a move, but this didn't happen here on the solverThread, so we can't detect it.");
        } else {
            analysis.append("  Impossible state. Maybe this is a bug in the scoreDirector (").append(this.getClass()).append(").");
        }
        return analysis.toString();
    }

    private Map<List<Object>, ConstraintMatch> createConstraintMatchMap(Collection<ConstraintMatchTotal> constraintMatchTotals) {
        LinkedHashMap<List<Object>, ConstraintMatch> constraintMatchMap = new LinkedHashMap<List<Object>, ConstraintMatch>(constraintMatchTotals.size() * 16);
        for (ConstraintMatchTotal constraintMatchTotal : constraintMatchTotals) {
            for (ConstraintMatch constraintMatch : constraintMatchTotal.getConstraintMatchSet()) {
                ConstraintMatch previousConstraintMatch = constraintMatchMap.put(Arrays.asList(constraintMatchTotal.getConstraintPackage(), constraintMatchTotal.getConstraintName(), constraintMatch.getJustificationList(), constraintMatch.getScore()), constraintMatch);
                if (previousConstraintMatch == null) continue;
                throw new IllegalStateException("Score corruption because the constraintMatch (" + constraintMatch + ") was added twice for constraintMatchTotal (" + constraintMatchTotal + ") without removal.");
            }
        }
        return constraintMatchMap;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.calculationCount + ")";
    }
}

