/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch.node.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;

public class DepthFirstNodeComparator
implements Comparator<ExhaustiveSearchNode>,
Serializable {
    private final boolean scoreBounderEnabled;

    public DepthFirstNodeComparator(boolean scoreBounderEnabled) {
        this.scoreBounderEnabled = scoreBounderEnabled;
    }

    @Override
    public int compare(ExhaustiveSearchNode a, ExhaustiveSearchNode b) {
        long bParentBreadth;
        long aParentBreadth;
        int bDepth;
        int aDepth = a.getDepth();
        if (aDepth < (bDepth = b.getDepth())) {
            return -1;
        }
        if (aDepth > bDepth) {
            return 1;
        }
        int scoreComparison = a.getScore().toInitializedScore().compareTo(b.getScore().toInitializedScore());
        if (scoreComparison < 0) {
            return -1;
        }
        if (scoreComparison > 0) {
            return 1;
        }
        if (this.scoreBounderEnabled) {
            int optimisticBoundComparison = a.getOptimisticBound().compareTo(b.getOptimisticBound());
            if (optimisticBoundComparison < 0) {
                return -1;
            }
            if (optimisticBoundComparison > 0) {
                return 1;
            }
        }
        if ((aParentBreadth = a.getParentBreadth()) < (bParentBreadth = b.getParentBreadth())) {
            return -1;
        }
        if (aParentBreadth > bParentBreadth) {
            return 1;
        }
        return Long.compare(b.getBreadth(), a.getBreadth());
    }
}

