/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsFilterTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsJoinTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsScoringTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriCondition;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.tri.InnerTriConstraintStream;

public abstract class DroolsAbstractTriConstraintStream<Solution_, A, B, C>
extends DroolsAbstractConstraintStream<Solution_>
implements InnerTriConstraintStream<A, B, C> {
    protected final DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent;

    public DroolsAbstractTriConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractTriConstraintStream<Solution_, A, B, C> parent) {
        super(constraintFactory);
        if (parent == null && !(this instanceof DroolsJoinTriConstraintStream)) {
            throw new IllegalArgumentException("The stream (" + this + ") must have a parent (null), unless it's a join stream.");
        }
        this.parent = parent;
    }

    @Override
    public TriConstraintStream<A, B, C> filter(TriPredicate<A, B, C> predicate) {
        DroolsFilterTriConstraintStream stream = new DroolsFilterTriConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    protected Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, boolean positive) {
        DroolsScoringTriConstraintStream stream = new DroolsScoringTriConstraintStream(this.constraintFactory, this);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntTriFunction<A, B, C> matchWeigher, boolean positive) {
        DroolsScoringTriConstraintStream stream = new DroolsScoringTriConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongTriFunction<A, B, C> matchWeigher, boolean positive) {
        DroolsScoringTriConstraintStream stream = new DroolsScoringTriConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher, boolean positive) {
        DroolsScoringTriConstraintStream stream = new DroolsScoringTriConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    protected Constraint impactScoreConfigurable(String constraintPackage, String constraintName, boolean positive) {
        DroolsScoringTriConstraintStream stream = new DroolsScoringTriConstraintStream(this.constraintFactory, this);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntTriFunction<A, B, C> matchWeigher, boolean positive) {
        DroolsScoringTriConstraintStream stream = new DroolsScoringTriConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongTriFunction<A, B, C> matchWeigher, boolean positive) {
        DroolsScoringTriConstraintStream stream = new DroolsScoringTriConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, TriFunction<A, B, C, BigDecimal> matchWeigher, boolean positive) {
        DroolsScoringTriConstraintStream stream = new DroolsScoringTriConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        if (this.parent == null) {
            DroolsJoinTriConstraintStream joinStream = (DroolsJoinTriConstraintStream)this;
            List leftParentFromStreamList = joinStream.getLeftParentStream().getFromStreamList();
            List rightParentFromStreamList = joinStream.getRightParentStream().getFromStreamList();
            return Stream.concat(leftParentFromStreamList.stream(), rightParentFromStreamList.stream()).collect(Collectors.toList());
        }
        return this.parent.getFromStreamList();
    }

    public abstract DroolsTriCondition<A, B, C> createCondition();
}

