/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.RuleItemBuilder;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block5;
import org.drools.model.functions.Predicate3;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsInferredMetadata;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsMetadata;

public final class DroolsTriCondition<A, B, C> {
    private final DroolsMetadata<Object, A> aMetadata;
    private final DroolsMetadata<Object, B> bMetadata;
    private final DroolsMetadata<Object, C> cMetadata;

    public DroolsTriCondition(DroolsMetadata<Object, A> aMetadata, DroolsMetadata<Object, B> bMetadata, DroolsMetadata<Object, C> cMetadata) {
        this.aMetadata = aMetadata;
        this.bMetadata = bMetadata;
        this.cMetadata = cMetadata;
    }

    public DroolsMetadata<Object, A> getAMetadata() {
        return this.aMetadata;
    }

    public DroolsMetadata<Object, B> getBMetadata() {
        return this.bMetadata;
    }

    public DroolsMetadata<Object, C> getCMetadata() {
        return this.cMetadata;
    }

    public DroolsTriCondition<A, B, C> andFilter(TriPredicate<A, B, C> predicate) {
        Predicate3 & Serializable filter = (Predicate3 & Serializable)(c, a, b) -> predicate.test(this.aMetadata.extract(a), this.bMetadata.extract(b), this.cMetadata.extract(c));
        Supplier patternSupplier = () -> this.cMetadata.buildPattern().expr("Filter using " + predicate, this.aMetadata.getVariableDeclaration(), this.bMetadata.getVariableDeclaration(), filter);
        return new DroolsTriCondition<A, B, C>(this.aMetadata, this.bMetadata, this.cMetadata.substitute(patternSupplier));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        return this.completeWithScoring(scoreHolderGlobal, (Block5 & Serializable)(drools, scoreHolder, __, ___, ____) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext);
        });
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToIntTriFunction<A, B, C> matchWeighter) {
        ToIntTriFunction<Object, Object, Object> weightMultiplier = (a, b, c) -> matchWeighter.applyAsInt(this.aMetadata.extract(a), this.bMetadata.extract(b), this.cMetadata.extract(c));
        return this.completeWithScoring(scoreHolderGlobal, (Block5 & Serializable)(drools, scoreHolder, a, b, c) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext, weightMultiplier.applyAsInt(a, b, c));
        });
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToLongTriFunction<A, B, C> matchWeighter) {
        ToLongTriFunction<Object, Object, Object> weightMultiplier = (a, b, c) -> matchWeighter.applyAsLong(this.aMetadata.extract(a), this.bMetadata.extract(b), this.cMetadata.extract(c));
        return this.completeWithScoring(scoreHolderGlobal, (Block5 & Serializable)(drools, scoreHolder, a, b, c) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext, weightMultiplier.applyAsLong(a, b, c));
        });
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, TriFunction<A, B, C, BigDecimal> matchWeighter) {
        TriFunction<Object, Object, Object, BigDecimal> weightMultiplier = (a, b, c) -> (BigDecimal)matchWeighter.apply(this.aMetadata.extract(a), this.bMetadata.extract(b), this.cMetadata.extract(c));
        return this.completeWithScoring(scoreHolderGlobal, (Block5 & Serializable)(drools, scoreHolder, a, b, c) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext, (BigDecimal)weightMultiplier.apply(a, b, c));
        });
    }

    private <ScoreHolder extends AbstractScoreHolder<?>> List<RuleItemBuilder<?>> completeWithScoring(Global<ScoreHolder> scoreHolderGlobal, Block5<Drools, ScoreHolder, Object, Object, Object> consequenceImpl) {
        ConsequenceBuilder._4 consequence = DSL.on(scoreHolderGlobal, this.aMetadata.getVariableDeclaration(), this.bMetadata.getVariableDeclaration(), this.cMetadata.getVariableDeclaration()).execute(consequenceImpl);
        if (this.aMetadata instanceof DroolsInferredMetadata && this.bMetadata instanceof DroolsInferredMetadata && this.cMetadata instanceof DroolsInferredMetadata) {
            return Arrays.asList(this.cMetadata.buildPattern(), consequence);
        }
        return Arrays.asList(this.aMetadata.buildPattern(), this.bMetadata.buildPattern(), this.cMetadata.buildPattern(), consequence);
    }
}

