/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.drools.core.base.accumulators.CollectSetAccumulateFunction;
import org.drools.model.Argument;
import org.drools.model.BetaIndex;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.DeclarationSource;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block2;
import org.drools.model.functions.Block3;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsGenuineMetadata;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsLogicalTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsMetadata;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniAccumulateFunctionBridge;

public final class DroolsUniCondition<A> {
    private final DroolsMetadata<Object, A> aMetadata;

    public DroolsUniCondition(Class<A> aVariableType) {
        Declaration aVariableDeclaration = DSL.declarationOf(aVariableType);
        this.aMetadata = DroolsMetadata.ofGenuine(aVariableDeclaration);
    }

    public DroolsUniCondition(Declaration<DroolsLogicalTuple> aVariableDeclaration, Function<Declaration<DroolsLogicalTuple>, PatternDSL.PatternDef<DroolsLogicalTuple>> patternProvider) {
        this.aMetadata = DroolsMetadata.ofInferred(aVariableDeclaration, () -> (PatternDSL.PatternDef)patternProvider.apply(aVariableDeclaration));
    }

    private DroolsUniCondition(DroolsMetadata<Object, A> aMetadata) {
        this.aMetadata = aMetadata;
    }

    public DroolsMetadata<Object, A> getAMetadata() {
        return this.aMetadata;
    }

    public DroolsUniCondition<A> andFilter(Predicate<A> predicate) {
        Predicate1<A> filter = DroolsUniCondition.filter(predicate, this.aMetadata);
        Supplier patternSupplier = () -> this.aMetadata.buildPattern().expr("Filter using " + predicate, filter);
        return new DroolsUniCondition<A>(this.aMetadata.substitute(patternSupplier));
    }

    private <B> PatternDSL.PatternDef<B> join(PatternDSL.PatternDef<B> pattern, DroolsMetadata<Object, B> bMetadata, AbstractBiJoiner<A, B> biJoiner, int mappingIndex) {
        JoinerType joinerType = biJoiner.getJoinerTypes()[mappingIndex];
        Function1 leftExtractor = DroolsUniCondition.transformingExtractor(biJoiner.getLeftMapping(mappingIndex), this.aMetadata);
        Function1 rightExtractor = DroolsUniCondition.transformingExtractor(biJoiner.getRightMapping(mappingIndex), bMetadata);
        Predicate2 & Serializable predicate = (Predicate2 & Serializable)(b, a) -> {
            Object left = leftExtractor.apply(a);
            Object right = rightExtractor.apply(b);
            return joinerType.matches(left, right);
        };
        BetaIndex betaIndex = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)DroolsUniCondition.getConstraintType(joinerType), (int)mappingIndex, rightExtractor, leftExtractor);
        Declaration<Object> aVariableDeclaration = this.aMetadata.getVariableDeclaration();
        return pattern.expr("Join using joiner #" + mappingIndex + " in " + biJoiner, aVariableDeclaration, (Predicate2)predicate, betaIndex);
    }

    private static <A> Predicate1<A> filter(Predicate<A> predicate, DroolsMetadata<Object, A> metadata) {
        if (metadata instanceof DroolsGenuineMetadata) {
            return predicate::test;
        }
        Function<Object, Object> extractor = metadata::extract;
        return (Predicate1 & Serializable)a -> predicate.test(extractor.apply(a));
    }

    private static <A, X> Function1<A, X> transformingExtractor(Function<A, X> mapping, DroolsMetadata<Object, A> metadata) {
        if (metadata instanceof DroolsGenuineMetadata) {
            return mapping::apply;
        }
        Function<Object, X> extractingMapper = mapping.compose(metadata::extract);
        return extractingMapper::apply;
    }

    public <B> DroolsBiCondition<A, B> andJoin(DroolsUniCondition<B> bCondition, AbstractBiJoiner<A, B> biJoiner) {
        DroolsMetadata<Object, A> bMetadata = bCondition.aMetadata;
        Supplier patternSupplier = () -> {
            PatternDSL.PatternDef pattern = bMetadata.buildPattern();
            JoinerType[] joinerTypes = biJoiner.getJoinerTypes();
            for (int mappingIndex = 0; mappingIndex < joinerTypes.length; ++mappingIndex) {
                pattern = this.join(pattern, bMetadata, biJoiner, mappingIndex);
            }
            return pattern;
        };
        return new DroolsBiCondition<A, A>(this.aMetadata, bMetadata.substitute(patternSupplier));
    }

    public <ResultContainer, NewA, NewB> List<RuleItemBuilder<?>> completeWithLogicalInsert(Object ruleId, Function<A, NewA> groupKeyMapping, UniConstraintCollector<A, ResultContainer, NewB> collector) {
        Function1 grouper = DroolsUniCondition.transformingExtractor(groupKeyMapping, this.aMetadata);
        Declaration innerNewADeclaration = DSL.declarationOf(Object.class);
        PatternDSL.PatternDef innerNewACollectingPattern = this.aMetadata.buildPattern().bind((Variable)innerNewADeclaration, grouper);
        Declaration setOfNewADeclaration = DSL.declarationOf(Collection.class);
        ExprViewItem collectingPattern = DSL.accumulate((ViewItem)innerNewACollectingPattern, (AccumulateFunction)DSL.accFunction(CollectSetAccumulateFunction::new, (Argument)innerNewADeclaration).as((Variable)setOfNewADeclaration), (AccumulateFunction[])new AccumulateFunction[0]);
        Declaration actualNewADeclaration = DSL.declarationOf(Object.class, (DeclarationSource)PatternDSL.from((Variable)setOfNewADeclaration));
        Predicate2 & Serializable matcher = (Predicate2 & Serializable)(a, newA) -> grouper.apply(a).equals(newA);
        BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)Index.ConstraintType.EQUAL, (int)0, arg_0 -> grouper.apply(arg_0), (Function1 & Serializable)u -> u);
        PatternDSL.PatternDef innerAccumulatePattern = this.aMetadata.buildPattern().expr("Filter by group key mapping " + groupKeyMapping, (Variable)actualNewADeclaration, (Predicate2)matcher, index).bind(this.aMetadata.getVariableDeclaration(), this.aMetadata::extract);
        DroolsUniAccumulateFunctionBridge accumulateFunction = new DroolsUniAccumulateFunctionBridge(collector);
        Declaration accumulateResultVariable = DSL.declarationOf(Object.class);
        ExprViewItem outerAccumulatePattern = DSL.accumulate((ViewItem)innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(() -> accumulateFunction, this.aMetadata.getVariableDeclaration()).as((Variable)accumulateResultVariable), (AccumulateFunction[])new AccumulateFunction[0]);
        ConsequenceBuilder._2 consequence = DSL.on((Variable)actualNewADeclaration, (Variable)accumulateResultVariable).execute((Block3 & Serializable)(drools, newA, newB) -> {
            RuleContext kcontext = (RuleContext)drools;
            kcontext.insertLogical((Object)new DroolsLogicalTuple(ruleId, newA, newB));
        });
        return Arrays.asList(collectingPattern, PatternDSL.pattern((Variable)setOfNewADeclaration), PatternDSL.pattern((Variable)actualNewADeclaration), outerAccumulatePattern, consequence);
    }

    public <ResultContainer, NewA> List<RuleItemBuilder<?>> completeWithLogicalInsert(Object ruleId, UniConstraintCollector<A, ResultContainer, NewA> collector) {
        DroolsMetadata<Object, A> inputMetadata = this.getAMetadata();
        Declaration<Object> inputVariable = inputMetadata.getVariableDeclaration();
        PatternDSL.PatternDef innerAccumulatePattern = inputMetadata.buildPattern().bind(inputVariable, inputMetadata::extract);
        DroolsUniAccumulateFunctionBridge accumulateFunction = new DroolsUniAccumulateFunctionBridge(collector);
        Declaration outputVariable = DSL.declarationOf(Object.class);
        ExprViewItem outerAccumulatePattern = DSL.accumulate((ViewItem)innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(() -> accumulateFunction, inputVariable).as((Variable)outputVariable), (AccumulateFunction[])new AccumulateFunction[0]);
        ConsequenceBuilder._1 consequence = DSL.on((Variable)outputVariable).execute((Block2 & Serializable)(drools, newA) -> {
            RuleContext kcontext = (RuleContext)drools;
            kcontext.insertLogical((Object)new DroolsLogicalTuple(ruleId, newA));
        });
        return Arrays.asList(outerAccumulatePattern, consequence);
    }

    public <GroupKey_> List<RuleItemBuilder<?>> completeWithLogicalInsert(Object ruleId, Function<A, GroupKey_> groupKeyMapping) {
        Function1 grouper = DroolsUniCondition.transformingExtractor(groupKeyMapping, this.aMetadata);
        ConsequenceBuilder._1 consequence = DSL.on(this.aMetadata.getVariableDeclaration()).execute((Block2 & Serializable)(drools, a) -> {
            Object aMapped = grouper.apply(a);
            RuleContext kcontext = (RuleContext)drools;
            kcontext.insertLogical((Object)new DroolsLogicalTuple(ruleId, aMapped));
        });
        return Arrays.asList(this.aMetadata.buildPattern(), consequence);
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, __) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext);
        });
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToIntFunction<A> matchWeighter) {
        ToIntFunction<Object> weightMultiplier = a -> matchWeighter.applyAsInt(this.aMetadata.extract(a));
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, a) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext, weightMultiplier.applyAsInt(a));
        });
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToLongFunction<A> matchWeighter) {
        ToLongFunction<Object> weightMultiplier = a -> matchWeighter.applyAsLong(this.aMetadata.extract(a));
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, a) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext, weightMultiplier.applyAsLong(a));
        });
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, Function<A, BigDecimal> matchWeighter) {
        Function<Object, BigDecimal> weightMultiplier = matchWeighter.compose(this.aMetadata::extract);
        return this.completeWithScoring(scoreHolderGlobal, (Block3 & Serializable)(drools, scoreHolder, a) -> {
            RuleContext kcontext = (RuleContext)drools;
            scoreHolder.impactScore(kcontext, (BigDecimal)weightMultiplier.apply(a));
        });
    }

    private <ScoreHolder extends AbstractScoreHolder<?>> List<RuleItemBuilder<?>> completeWithScoring(Global<ScoreHolder> scoreHolderGlobal, Block3<Drools, ScoreHolder, Object> consequenceImpl) {
        ConsequenceBuilder._2 consequence = DSL.on(scoreHolderGlobal, this.aMetadata.getVariableDeclaration()).execute(consequenceImpl);
        return Arrays.asList(this.aMetadata.buildPattern(), consequence);
    }

    public static Index.ConstraintType getConstraintType(JoinerType type) {
        switch (type) {
            case EQUAL: {
                return Index.ConstraintType.EQUAL;
            }
            case LESS_THAN: {
                return Index.ConstraintType.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return Index.ConstraintType.LESS_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Index.ConstraintType.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return Index.ConstraintType.GREATER_OR_EQUAL;
            }
        }
        throw new IllegalStateException("Unsupported joiner type (" + (Object)((Object)type) + ").");
    }
}

