/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.tri;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.SingleTriJoiner;

public final class CompositeTriJoiner<A, B, C>
extends AbstractTriJoiner<A, B, C> {
    private final List<SingleTriJoiner<A, B, C>> joinerList;
    private final BiFunction<A, B, ?>[] leftMappings;
    private final Function<C, ?>[] rightMappings;

    public CompositeTriJoiner(List<SingleTriJoiner<A, B, C>> joinerList) {
        if (joinerList.isEmpty()) {
            throw new IllegalArgumentException("The joinerList (" + joinerList + ") must not be empty.");
        }
        this.joinerList = joinerList;
        this.leftMappings = (BiFunction[])joinerList.stream().map(SingleTriJoiner::getLeftMapping).toArray(BiFunction[]::new);
        this.rightMappings = (Function[])joinerList.stream().map(SingleTriJoiner::getRightMapping).toArray(Function[]::new);
    }

    public List<SingleTriJoiner<A, B, C>> getJoinerList() {
        return this.joinerList;
    }

    @Override
    public BiFunction<A, B, Object> getLeftMapping(int joinerId) {
        return this.leftMappings[joinerId];
    }

    @Override
    public BiFunction<A, B, Object[]> getLeftCombinedMapping() {
        BiFunction[] mappings = (BiFunction[])IntStream.range(0, this.joinerList.size()).mapToObj(this::getLeftMapping).toArray(BiFunction[]::new);
        return (a, b) -> Arrays.stream(mappings).map(f -> f.apply(a, b)).toArray();
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return (JoinerType[])this.joinerList.stream().map(SingleTriJoiner::getJoinerType).toArray(JoinerType[]::new);
    }

    @Override
    public Function<C, Object> getRightMapping(int joinerId) {
        return this.rightMappings[joinerId];
    }

    @Override
    public Function<C, Object[]> getRightCombinedMapping() {
        Function[] mappings = (Function[])IntStream.range(0, this.joinerList.size()).mapToObj(this::getRightMapping).toArray(Function[]::new);
        return c -> Arrays.stream(mappings).map(f -> f.apply(c)).toArray();
    }
}

