/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class LongSumAccumulateFunction
extends AbstractAccumulateFunction<SumData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public SumData createContext() {
        return new SumData();
    }

    public void init(SumData data) {
        data.total = 0L;
    }

    public void accumulate(SumData data, Object value) {
        if (value != null) {
            data.total += ((Long)value).longValue();
        }
    }

    public void reverse(SumData data, Object value) {
        if (value != null) {
            data.total -= ((Long)value).longValue();
        }
    }

    public Object getResult(SumData data) {
        return data.total;
    }

    public boolean supportsReverse() {
        return true;
    }

    public Class<?> getResultType() {
        return Long.class;
    }

    protected static class SumData
    implements Externalizable {
        public long total = 0L;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.total);
        }
    }
}

