/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalablePool<T> {
    private static final Logger log = LoggerFactory.getLogger(ScalablePool.class);
    private final Queue<T> pool = new ConcurrentLinkedQueue<T>();
    private final List<T> resources = Collections.synchronizedList(new ArrayList());
    private final Supplier<? extends T> supplier;
    private final Consumer<? super T> resetter;
    private final Consumer<? super T> disposer;

    public ScalablePool(int initialSize, Supplier<? extends T> supplier, Consumer<? super T> resetter, Consumer<? super T> disposer) {
        this.supplier = supplier;
        this.resetter = resetter;
        this.disposer = disposer;
        for (int i = 0; i < initialSize; ++i) {
            T t = this.supplier.get();
            this.pool.offer(t);
            this.resources.add(t);
        }
    }

    public T get() {
        T t = this.pool.poll();
        if (t != null) {
            return t;
        }
        t = this.supplier.get();
        this.resources.add(t);
        return t;
    }

    public void release(T t) {
        this.resetter.accept(t);
        this.pool.offer(t);
    }

    public void shutdown() {
        for (T t : this.resources) {
            this.disposer.accept(t);
        }
        this.pool.clear();
        this.resources.clear();
    }
}

