/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.flightcrewscheduling.persistence;

import java.io.File;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.generator.LocationDataGenerator;
import org.optaplanner.examples.common.persistence.generator.ProbabilisticDataGenerator;
import org.optaplanner.examples.common.persistence.generator.StringDataGenerator;
import org.optaplanner.examples.flightcrewscheduling.domain.Airport;
import org.optaplanner.examples.flightcrewscheduling.domain.Employee;
import org.optaplanner.examples.flightcrewscheduling.domain.Flight;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightAssignment;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightCrewParametrization;
import org.optaplanner.examples.flightcrewscheduling.domain.FlightCrewSolution;
import org.optaplanner.examples.flightcrewscheduling.domain.Skill;
import org.optaplanner.examples.flightcrewscheduling.persistence.FlightCrewSchedulingXlsxFileIO;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class FlightCrewSchedulingGenerator
extends LoggingMain {
    private static final double TAXI_KM_THRESHOLD = 500.0;
    private static final double TAXI_SPEED_IN_KM_PER_MINUTE = 1.5;
    private static final double PLANE_SPEED_IN_KM_PER_MINUTE = 16.666666666666668;
    private static final double PLANE_TAKE_OFF_AND_LANDING_MINUTES = 90.0;
    private static final int START_MINUTE_OF_DAY = 360;
    private static final int END_MINUTE_OF_DAY = 1320;
    private static final int PILOT_COUNT_PER_FLIGHT = 2;
    private static final int FLIGHT_ATTENDANT_COUNT_PER_FLIGHT = 3;
    private static final int EMPLOYEE_COUNT_PER_FLIGHT = 5;
    private final StringDataGenerator employeeNameGenerator = StringDataGenerator.buildFullNames();
    protected final SolutionFileIO<FlightCrewSolution> solutionFileIO = new FlightCrewSchedulingXlsxFileIO();
    protected final File outputDir = new File(CommonApp.determineDataDir("flightcrewscheduling"), "unsolved");
    protected Skill pilotSkill;
    protected Skill flightAttendantSkill;
    protected List<Airport> homeAirportList;
    protected Random random;

    public static void main(String[] args) {
        FlightCrewSchedulingGenerator generator = new FlightCrewSchedulingGenerator();
        generator.writeFlightCrewSolution("Europe", LocationDataGenerator.EUROPE_BUSIEST_AIRPORTS, 10, 7);
        generator.writeFlightCrewSolution("Europe", LocationDataGenerator.EUROPE_BUSIEST_AIRPORTS, 10, 28);
        generator.writeFlightCrewSolution("Europe", LocationDataGenerator.EUROPE_BUSIEST_AIRPORTS, 50, 7);
        generator.writeFlightCrewSolution("US", LocationDataGenerator.US_MAINLAND_STATE_CAPITALS, 10, 7);
    }

    private void writeFlightCrewSolution(String locationDataName, LocationDataGenerator.LocationData[] locationDataArray, int flightRoundTripsPerDay, int dayCount) {
        int flightListSize = flightRoundTripsPerDay * 5 / 2 * dayCount;
        String fileName = flightListSize + "flights-" + dayCount + "days-" + locationDataName;
        File outputFile = new File(this.outputDir, fileName + "." + this.solutionFileIO.getOutputFileExtension());
        FlightCrewSolution solution = this.createFlightCrewSolution(fileName, locationDataArray, flightRoundTripsPerDay, dayCount);
        this.solutionFileIO.write((Object)solution, outputFile);
    }

    public FlightCrewSolution createFlightCrewSolution(String fileName, LocationDataGenerator.LocationData[] locationDataArray, int flightRoundTripsPerDay, int dayCount) {
        this.random = new Random(37L);
        FlightCrewSolution solution = new FlightCrewSolution();
        solution.setId(0L);
        LocalDate firstDate = LocalDate.of(2018, 1, 1);
        solution.setScheduleFirstUTCDate(firstDate);
        solution.setScheduleLastUTCDate(firstDate.plusDays(dayCount - 1));
        FlightCrewParametrization parametrization = new FlightCrewParametrization();
        parametrization.setId(0L);
        solution.setParametrization(parametrization);
        this.createSkillList(solution);
        this.createAirportList(solution, locationDataArray);
        this.createFlightList(solution, flightRoundTripsPerDay, dayCount);
        this.createFlightAssignmentList(solution);
        this.createEmployeeList(solution, flightRoundTripsPerDay, dayCount);
        int employeeListSize = solution.getEmployeeList().size();
        int flightAssignmentListSize = solution.getFlightAssignmentList().size();
        BigInteger possibleSolutionSize = BigInteger.valueOf(employeeListSize).pow(flightAssignmentListSize);
        this.logger.info("FlightCrew {} has {} skills, {} airports, {} employees, {} flights and {} flight assignments with a search space of {}.", new Object[]{fileName, solution.getSkillList().size(), solution.getAirportList().size(), solution.getEmployeeList().size(), solution.getFlightList().size(), flightAssignmentListSize, AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return solution;
    }

    private void createSkillList(FlightCrewSolution solution) {
        ArrayList<Skill> skillList = new ArrayList<Skill>(2);
        this.pilotSkill = new Skill();
        this.pilotSkill.setId(0L);
        this.pilotSkill.setName("Pilot");
        skillList.add(this.pilotSkill);
        this.flightAttendantSkill = new Skill();
        this.flightAttendantSkill.setId(1L);
        this.flightAttendantSkill.setName("Flight attendant");
        skillList.add(this.flightAttendantSkill);
        solution.setSkillList(skillList);
    }

    private void createAirportList(FlightCrewSolution solution, LocationDataGenerator.LocationData[] locationDataArray) {
        ArrayList<Airport> airportList = new ArrayList<Airport>(locationDataArray.length);
        long id = 0L;
        for (LocationDataGenerator.LocationData locationData : locationDataArray) {
            Airport airport = new Airport();
            airport.setId(id);
            ++id;
            airport.setCode(locationData.getName().replaceAll("\\,.*", ""));
            airport.setName(locationData.getName());
            airport.setLatitude(locationData.getLatitude());
            airport.setLongitude(locationData.getLongitude());
            this.logger.trace("Created airport ({}).", (Object)airport);
            airportList.add(airport);
        }
        for (Airport a : airportList) {
            LinkedHashMap<Airport, Long> taxiTimeInMinutesMap = new LinkedHashMap<Airport, Long>(airportList.size());
            for (Airport b : airportList) {
                double distanceInKm = a.getHaversineDistanceInKmTo(b);
                if (!(distanceInKm < 500.0)) continue;
                taxiTimeInMinutesMap.put(b, (long)(distanceInKm / 1.5));
            }
            a.setTaxiTimeInMinutesMap(taxiTimeInMinutesMap);
        }
        solution.setAirportList(airportList);
    }

    private void createFlightList(FlightCrewSolution solution, int flightRoundTripsPerDay, int dayCount) {
        int flightListSize = flightRoundTripsPerDay * dayCount;
        ArrayList<Flight> flightList = new ArrayList<Flight>(flightListSize);
        List<Airport> airportList = solution.getAirportList();
        Airport centerAirport = airportList.get(0);
        int homeAirportListSize = Math.min(airportList.size() / 10, flightRoundTripsPerDay / 5);
        this.homeAirportList = airportList.stream().sorted(Comparator.comparingDouble(centerAirport::getHaversineDistanceInKmTo)).limit(homeAirportListSize).collect(Collectors.toList());
        LocalDate firstDate = solution.getScheduleFirstUTCDate();
        LocalDate lastDate = solution.getScheduleLastUTCDate();
        int flightNumberSuffix = 1;
        long flightId = 0L;
        for (int i = 0; i < flightRoundTripsPerDay; ++i) {
            int flightCount = i % 2 == 0 ? 2 : 3;
            ArrayList<Airport> selectedAirports = new ArrayList<Airport>(flightCount);
            Airport firstAirport = ProbabilisticDataGenerator.extractRandomElement(this.random, this.homeAirportList);
            selectedAirports.add(firstAirport);
            ArrayList<Airport> nonFirstAirports = new ArrayList<Airport>(airportList);
            nonFirstAirports.remove(firstAirport);
            Collections.shuffle(nonFirstAirports, this.random);
            selectedAirports.addAll(nonFirstAirports.subList(0, flightCount - 1));
            for (int j = 0; j < flightCount; ++j) {
                String flightNumber = "AB" + String.format("%03d", flightNumberSuffix);
                ++flightNumberSuffix;
                Airport departureAirport = (Airport)selectedAirports.get(j);
                Airport arrivalAirport = (Airport)selectedAirports.get((j + 1) % flightCount);
                int flyingTime = (int)(departureAirport.getHaversineDistanceInKmTo(arrivalAirport) / 16.666666666666668 + 90.0);
                int departureMinute = 360 + this.random.nextInt(1320 - flyingTime - 360 + 1);
                int arrivalMinute = departureMinute + flyingTime;
                LocalDate date = firstDate;
                while (date.compareTo(lastDate) <= 0) {
                    Flight flight = new Flight();
                    flight.setId(flightId);
                    ++flightId;
                    flight.setFlightNumber(flightNumber);
                    flight.setDepartureAirport(departureAirport);
                    flight.setDepartureUTCDateTime(date.atTime(departureMinute / 60, departureMinute % 60));
                    flight.setArrivalAirport(arrivalAirport);
                    flight.setArrivalUTCDateTime(date.atTime(arrivalMinute / 60, arrivalMinute % 60));
                    this.logger.trace("Created flight ({}).", (Object)flight);
                    flightList.add(flight);
                    date = date.plusDays(1L);
                }
            }
        }
        flightList.sort(Flight::compareTo);
        solution.setFlightList(flightList);
    }

    private void createFlightAssignmentList(FlightCrewSolution solution) {
        List<Flight> flightList = solution.getFlightList();
        ArrayList<FlightAssignment> flightAssignmentList = new ArrayList<FlightAssignment>(flightList.size() * 5);
        long flightAssignmentId = 0L;
        for (Flight flight : flightList) {
            for (int indexInFlight = 0; indexInFlight < 5; ++indexInFlight) {
                FlightAssignment flightAssignment = new FlightAssignment();
                flightAssignment.setId(flightAssignmentId);
                ++flightAssignmentId;
                flightAssignment.setFlight(flight);
                flightAssignment.setIndexInFlight(indexInFlight);
                Skill requiredSkill = indexInFlight < 2 ? this.pilotSkill : this.flightAttendantSkill;
                flightAssignment.setRequiredSkill(requiredSkill);
                flightAssignmentList.add(flightAssignment);
            }
        }
        solution.setFlightAssignmentList(flightAssignmentList);
    }

    private void createEmployeeList(FlightCrewSolution solution, int flightRoundTripsPerDay, int dayCount) {
        int employeeListSize = flightRoundTripsPerDay * 5 * 3;
        ArrayList<Employee> employeeList = new ArrayList<Employee>(employeeListSize);
        this.employeeNameGenerator.predictMaximumSizeAndReset(employeeListSize);
        LocalDate firstDate = solution.getScheduleFirstUTCDate();
        LocalDate lastDate = solution.getScheduleLastUTCDate();
        ArrayList<LocalDate> allDateList = new ArrayList<LocalDate>((int)ChronoUnit.DAYS.between(firstDate, lastDate) + 1);
        LocalDate date = firstDate;
        while (date.compareTo(lastDate) <= 0) {
            allDateList.add(date);
            date = date.plusDays(1L);
        }
        ArrayList<LocalDate> unavailableDayPool = new ArrayList<LocalDate>(allDateList);
        Collections.shuffle(unavailableDayPool, this.random);
        long id = 0L;
        for (int i = 0; i < employeeListSize; ++i) {
            Employee employee = new Employee();
            employee.setId(id);
            ++id;
            employee.setName(this.employeeNameGenerator.generateNextValue());
            employee.setHomeAirport(ProbabilisticDataGenerator.extractRandomElement(this.random, this.homeAirportList));
            employee.setSkillSet(Collections.singleton(i % 5 < 2 ? this.pilotSkill : this.flightAttendantSkill));
            int unavailableDayCount = 0;
            for (int j = 0; j < dayCount && unavailableDayCount < dayCount; ++j) {
                if (!(this.random.nextDouble() < 0.0547945205479452)) continue;
                ++unavailableDayCount;
            }
            employee.setUnavailableDaySet(this.generateUnavailableDaySet(unavailableDayCount, allDateList, unavailableDayPool));
            employee.setFlightAssignmentSet(new TreeSet<FlightAssignment>());
            this.logger.trace("Created employee ({}).", (Object)employee);
            employeeList.add(employee);
        }
        solution.setEmployeeList(employeeList);
    }

    private Set<LocalDate> generateUnavailableDaySet(int size, List<LocalDate> allDateList, List<LocalDate> pool) {
        LinkedHashSet<LocalDate> unavailableDaySet = new LinkedHashSet<LocalDate>(size);
        if (pool.size() < size) {
            unavailableDaySet.addAll(pool);
            pool.clear();
            pool.addAll(allDateList);
            Collections.shuffle(pool, this.random);
            Iterator<LocalDate> it = pool.iterator();
            while (it.hasNext() && unavailableDaySet.size() < size) {
                LocalDate date = it.next();
                if (!unavailableDaySet.add(date)) continue;
                it.remove();
            }
        } else {
            List<LocalDate> selection = pool.subList(0, size);
            unavailableDaySet.addAll(selection);
            selection.clear();
        }
        return unavailableDaySet;
    }
}

