/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.util.Collections;
import java.util.List;
import java.util.function.LongSupplier;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsPatternBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;

public class DroolsQuadRuleStructure<A, B, C, D>
extends DroolsRuleStructure {
    private final Variable<A> a;
    private final Variable<B> b;
    private final Variable<C> c;
    private final Variable<D> d;
    private final DroolsPatternBuilder<?> primaryPattern;
    private final List<RuleItemBuilder<?>> supportingRuleItems;

    public DroolsQuadRuleStructure(DroolsTriRuleStructure<A, B, C> abcRuleStructure, DroolsUniRuleStructure<D> dRuleStructure, LongSupplier variableIdSupplier) {
        super(variableIdSupplier);
        this.a = abcRuleStructure.getA();
        this.b = abcRuleStructure.getB();
        this.c = abcRuleStructure.getC();
        this.d = dRuleStructure.getA();
        this.primaryPattern = dRuleStructure.getPrimaryPattern();
        List<RuleItemBuilder<?>> ruleItems = abcRuleStructure.rebuildSupportingRuleItems(new RuleItemBuilder[]{abcRuleStructure.getPrimaryPattern().build()});
        ruleItems.addAll(dRuleStructure.getSupportingRuleItems());
        this.supportingRuleItems = Collections.unmodifiableList(ruleItems);
    }

    public DroolsQuadRuleStructure(Variable<A> aVariable, Variable<B> bVariable, Variable<C> cVariable, Variable<D> dVariable, DroolsPatternBuilder<?> primaryPattern, List<RuleItemBuilder<?>> supportingRuleItems, LongSupplier variableIdSupplier) {
        super(variableIdSupplier);
        this.a = aVariable;
        this.b = bVariable;
        this.c = cVariable;
        this.d = dVariable;
        this.primaryPattern = primaryPattern;
        this.supportingRuleItems = supportingRuleItems;
    }

    public Variable<A> getA() {
        return this.a;
    }

    public Variable<B> getB() {
        return this.b;
    }

    public Variable<C> getC() {
        return this.c;
    }

    public Variable<D> getD() {
        return this.d;
    }

    @Override
    public DroolsPatternBuilder<Object> getPrimaryPattern() {
        return this.primaryPattern;
    }

    @Override
    public List<RuleItemBuilder<?>> getSupportingRuleItems() {
        return this.supportingRuleItems;
    }
}

